/*
 * @Description: 布局抽象类
 * @Author: huangtianyang
 * @Date: 2020-01-13 15:56
 */
import { Bind } from 'lodash-decorators';
import React, { Component } from 'react';

/**
 * @extends {Component}
 * @ReactProps {React.ReactElement} components
 */
class AbstractLayout extends Component {
  constructor(props) {
    super(props);
    this.counter = 0;
  }

  /**
   *  包装渲染布局下组件
   * @param {Array.<React.ReactElement>} components 组件
   */
  @Bind()
  packageContents(components) {
    return components;
  }

  @Bind()
  getCounter() {
    this.counter += 1;
    return this.counter;
  }

  /**
   *  获取框架
   * @param {*} content
   * @returns {React.ReactElement}
   */
  @Bind()
  getLayoutFrame(content) {
    return <div>{content}</div>;
  }

  render() {
    const { components } = this.props;
    return <>{this.getLayoutFrame(this.packageContents(components))}</>;
  }
}

export default AbstractLayout;
