/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-29 10:10:04
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-07-31 18:52:20
 * @Version: 1.0.0
 * @Description: 
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue'
import Router from 'vue-router'

// test工具类
import Radio from '@/pages/radioTest'
import Form from '@/pages/form'

const TestDynamic = resolve => require.ensure([], () => { resolve(require('@/pages/testDynamic')) }, 'testDynamic')
const DynamicDetail = resolve => require.ensure([], () => { resolve(require('@/pages/dynamicDetail')) }, 'dynamicDetail')
const Demo = resolve => require.ensure([], () => { resolve(require('@/pages/demo')) }, 'demo')
const Home = resolve => require.ensure([], () => { resolve(require('@/pages/home')) }, 'home')
const HlsPopup = resolve => require.ensure([], () => { resolve(require('@/pages/hlsPopup')) }, 'hlsPopup')
const HFile = () => import(/* webpackChunkName:'HFile' */ '@/pages/fileTest')
const scrollTest = resolve => require.ensure([], () => { resolve(require('@/pages/scrollTest')) }, 'scroll')

const Header = resolve => require.ensure([], () => { resolve(require('@/pages/Header/demo')) }, 'header')
const Tab = resolve => require.ensure([], () => { resolve(require('@/pages/STab/index')) }, 'stab')
const Button = resolve => require.ensure([], () => { resolve(require('@/pages/Button/demo')) }, 'button')
const Content = resolve => require.ensure([], () => { resolve(require('@/pages/Content/demo')) }, 'content')
const Scroll = resolve => require.ensure([], () => { resolve(require('@/pages/Scroll/demo')) }, 'scroll')
const BottomTab = resolve => require.ensure([], () => { resolve(require('@/pages/BottomTab/demo')) }, 'BottomTab')
const Model = resolve => require.ensure([], () => { resolve(require('@/pages/Model/demo')) }, 'model')
const Swipe = resolve => require.ensure([], () => { resolve(require('@/pages/Swipe/demo')) }, 'swipe')
const List = resolve => require.ensure([], () => { resolve(require('@/pages/List/demo')) }, 'list')
const ItemOption = resolve => require.ensure([], () => { resolve(require('@/pages/ItemOption/demo')) }, 'option')
const File = resolve => require.ensure([], () => { resolve(require('@/pages/HFile/demo')) }, 'file')
const Field = resolve => require.ensure([], () => { resolve(require('@/pages/Field/demo')) }, 'field')
const CurrencyInput = resolve => require.ensure([], () => { resolve(require('@/pages/CurrencyInput/demo')) }, 'currencyInput')
const CheckBox = resolve => require.ensure([], () => { resolve(require('@/pages/CheckBox/demo')) }, 'checkBox')
const DateField = resolve => require.ensure([], () => { resolve(require('@/pages/DateField/demo')) }, 'dateField')
const Sign = resolve => require.ensure([], () => { resolve(require('@/pages/Sign')) }, 'Sign')

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/testDynamic',
    },
    {path: '/testDynamic', component: TestDynamic, name: 'TestDynamic', meta: {keepAlive: true}},
    {path: '/dynamicDetail', component: DynamicDetail, name: 'DynamicDetail', meta: {keepAlive: true}},
    {path: '/demo', component: Demo, name: 'Demo', meta: {keepAlive: true}},
    {path: '/home', component: Home, name: 'Home', meta: {keepAlive: false}},
    // test工具类
    {path: '/hlsPopup', component: HlsPopup, name: 'HlsPopup', meta: {keepAlive: false}},
    {path: '/Radio', component: Radio, name: 'Radio', meta: {keepAlive: true}},
    {path: '/HFile', component: HFile, name: 'HFile', meta: {keepAlive: true}},
    {path: '/Form', component: Form, name: 'Form', meta: {keepAlive: true}},
    {path: '/scrollTest', component: scrollTest, name: 'scrollTest', meta: {keepAlive: true}},

    {path: '/header', component: Header, name: 'Header', meta: {keepAlive: false}},
    {path: '/tab', component: Tab, name: 'Tab', meta: {keepAlive: false}},
    {path: '/button', component: Button, name: 'Button', meta: {keepAlive: false}},
    {path: '/content', component: Content, name: 'Content', meta: {keepAlive: false}},
    {path: '/scroll', component: Scroll, name: 'Scroll', meta: {keepAlive: false}},
    {path: '/bottomTab', component: BottomTab, name: 'BottomTab', meta: {keepAlive: false}},
    {path: '/model', component: Model, name: 'Model', meta: {keepAlive: false}},
    {path: '/swipe', component: Swipe, name: 'Swipe', meta: {keepAlive: false}},
    {path: '/list', component: List, name: 'List', meta: {keepAlive: false}},
    {path: '/option', component: ItemOption, name: 'ItemOption', meta: {keepAlive: false}},
    {path: '/file', component: File, name: 'File', meta: {keepAlive: false}},
    {path: '/field', component: Field, name: 'Field', meta: {keepAlive: false}},
    {path: '/currencyInput', component: CurrencyInput, name: 'CurrencyInput', meta: {keepAlive: false}},
    {path: '/checkBox', component: CheckBox, name: 'CheckBox', meta: {keepAlive: false}},
    {path: '/dateField', component: DateField, name: 'DateField', meta: {keepAlive: false}},
    {path: '/Sign', component: Sign, name: 'Sign', meta: {keepAlive: false}},

  ],
  scrollBehavior (to, from, savedPosition) {
    if (to.hash) {
      return {
        selector: to.hash,
      }
    }
  },
})
