/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-30 14:39:47
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-15 17:02:23
 * @Version: 1.0.0
 * @Description: 工具类
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
const getCustomizedProp = (layoutCode, tabCode, columnName, props) => {
  return props.filter(
    value =>
      value.columnName === columnName &&
      (!value.tabCode || value.tabCode === tabCode) &&
      (!value.layoutCode || value.layoutCode === layoutCode)
  );
};

const getCustomized = (layoutCode, tabCode, columnName, props) => {
  const customizedProp = getCustomizedProp(layoutCode, tabCode, columnName, props);
  return customizedProp.length > 0 ? customizedProp[0] : {};
};

const getHeaderExtrasProp = (layoutCode, tabCode, props) => {
  return props.filter(
    value =>
      (!value.tabCode || value.tabCode === tabCode) &&
      (!value.layoutCode || value.layoutCode === layoutCode)
  );
};

const getDataSetName = (config, tabCode) => {
  return config[tabCode].dataSetName || '';
};

const suppField = (num) => { // 补充显示
  return `${num < 10 ? `0`: ''}${num}`;
}

/**
 * 日期格式话
 * @param {*} type 日期类型
 * @param {*} time date类型
 * @returns 
 */
const dateFormat = (type, time) => { // 时间格式化 2019-09-08
  let year = time.getFullYear();
  let month = suppField(time.getMonth() + 1);
  let day = suppField(time.getDate());
  let hour = suppField(time.getHours());
  let minutes = suppField(time.getMinutes());
  let seconds = suppField(time.getSeconds());
  let dateDescription = `${year}-${month}-${day}`;
  let dateValue = `${year}-${month}-${day}`;
  if (['time', 'dateTime'].includes(type)) {
    dateDescription = `${year}-${month}-${day} ${hour}:${minutes}:${seconds}`;
    dateValue = dateDescription;

  } else if (type === 'month') { // 月
    dateDescription = `${year}-${month}`;
    dateValue = `${year}-${month}-01`;

  } else if (type === 'year') { // 年
    dateDescription = `${year}`;
    dateValue = `${year}-00-00`;

  } else if (type === 'week') { // 周
    const firstDayOfYear = new Date(year, 0, 1);  // 获取当年的第一天
    const pastDaysOfYear = (time - firstDayOfYear) / 86400000;  // 计算已经过去的天数
    const weekNum = Math.ceil((pastDaysOfYear + firstDayOfYear.getDay() + 1) / 7);  // 计算当前日期是第几周
    dateDescription = `${year}-${weekNum}周`;
  }
  return {
    value: dateValue,
    description: dateDescription
  }
};

const getOrganizationId = () => {
  return 0;
  // const globalState = getDvaApp()._store.getState();
  // const user = globalState.user || {};
  // switch (system) {
  //   case 'hls': // return getCurrentOrganizationId();
  //   case 'hcf':
  //     // return  0;
  //     return user?.currentUser.tenantId;
  //   default:
  //     break;
  // }
};

const getCurrentUser = () => {
  return {
    "id": 1,
    "loginName": "admin",
    "email": "admin@hzero.com",
    "organizationId": 0,
    "realName": "超级管理员",
    "phone": "18666666661",
    "internationalTelCode": "+86",
    "imageUrl": "http://hlsapp.hand-china.com/hls-file/public/hiam02/0/fd6ca1bdf3254e499b568f15cb8d3f51@WechatIMG775.jpg",
    "language": "zh_CN",
    "languageName": "简体中文",
    "timeZone": "GMT+8",
    "lastPasswordUpdatedAt": "2024-06-05 11:38:35",
    "countryId": 1,
    "countryName": "安道尔",
    "regionId": 0,
    "phoneCheckFlag": 1,
    "emailCheckFlag": 1,
    "passwordResetFlag": 1,
    "tenantName": "融租易",
    "tenantNum": "HLS",
    "dateFormat": "YYYY-MM-DD",
    "timeFormat": "HH:mm:ss",
    "dateTimeFormat": "YYYY-MM-DD HH:mm:ss",
    "changePasswordFlag": 0,
    "title": "融租易5.0",
    "logo": "http://leafdev.hand-china.com/hls-file/public/hpfm05/0/d21ff00430f146caa234a8e5ddde2320@融租易icon.png",
    "menuLayout": "inline",
    "menuLayoutTheme": "default",
    "roleMergeFlag": 0,
    "tenantId": 0,
    "currentRoleId": 1,
    "currentRoleCode": "role/organization/default/administrator",
    "currentRoleName": "租户管理员",
    "currentRoleLevel": "organization",
    "currentRoleLabels": [
        "TENANT_ADMIN"
    ],
    "favicon": "",
    "dataHierarchyFlag": 0,
    "recentAccessTenantList": []
};
};


export { 
  getCustomizedProp, 
  getCustomized,
  getHeaderExtrasProp,
  getDataSetName,
  dateFormat,
  getOrganizationId, 
  getCurrentUser 
};
