/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-08-09 10:54:02
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-09 14:42:17
 * @Version: 1.0.0
 * @Description: 页面配置请求
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import {getOrganizationId} from './utils/utils';
import {get} from './utils/hlsHttp'

export async function query(layoutCode, param) {
  let config = {
    datas: {},
    param: {},
  };
  try {
    const data = await get(`/hllc/v1/${getOrganizationId()}/doc-layouts/config/app/${layoutCode}`, param);
    config.param = param;
    config.datas = data || {};
    return config;
  } catch (err) {
    return config;
  }
}

export async function queryRoute(match, param) {
  let config = {
    datas: {},
    param: {},
  };
  try {
    const res = await get(
      `/hllc/v1/${getOrganizationId()}/rule-engine-low-code?route=${window.encodeURIComponent(
        match
      )}`
    );
    if (res) {
      const data = await this.query(res.routeResultValue, param);
      return data;
    } else {
      return config;
    }
  } catch (err) {
    return config;
  }
  
}
