/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-08-02 11:06:33
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-15 16:44:04
 * @Version: 1.0.0
 * @Description: 
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue';
import { Tab, Tabs } from 'vant';
import './index.less';

const DTabs = {
  name: 'DTabs',
  components: {
    [Tab.name]: Tab,
    [Tabs.name]: Tabs
  },
  props: {
    components: {
      type: Array,
      default: () => []
    },
    componentNames: {
      type: Array,
      default: () => []
    }
  },
  render: function (h, context) {
    return (
      <van-tabs type="card" class="d-tabs" swipe-threshold="3">
        {this.components.map((component, index) => (
          <van-tab 
            title={this.componentNames[index].label} 
            key={this.componentNames[index].code}
          >
            {component}
          </van-tab>
        ))}
      </van-tabs>
    )
    
  }
}

export default DTabs;

