/*
 * @Description: In User Settings Edit
 * @Author: huangtianyang
 * @Date: 2020-04-02 12:10
 */
import { Form } from 'leaf-ui/pro';
import { omit } from 'lodash';
import { omitFormConfigProps } from './formConfigConstant';
import React, { Component } from 'react';
import classNames from 'classnames';
import intl from 'utils/intl';
import png from './img/down.png';
import style from './index.less';

class HlsForm extends Component {
  constructor(props) {
    super(props);
    this.state = {
      isButtonShown: this.props.buttons && this.props.buttons.length > 0,
      hidden: process.env.REACT_APP_FORM_FOLD === 'true'
    };
  }

  render() {
    const queryFieldsLimit = this.props.columns;
    const handleToggle = () => {
      const { hidden } = this.state;
      this.setState({
        hidden: !hidden
      });
    };
    return (
      <div className={style['hls-from']}>
        <div className={style.form}>
          <Form
            ref={ref => {
              this.props && this.props.setRef(ref);
            }}
            {...omit(this.props, omitFormConfigProps)}
            onKeyDown={e => {
              if (e.keyCode === 13 && this.props.buttons) {
                this.props.buttons.some(button => {
                  if (button.key === 'query') {
                    button.props.onClick();
                    return true;
                  }
                  return false;
                });
              }
            }}
          >
            {!this.state.hidden && this.state.isButtonShown
              ? this.props.children && this.props.children.slice(0, queryFieldsLimit)
              : this.props.children}
          </Form>
        </div>
        <div
          className={style.buttons}
          style={{ display: this.state.isButtonShown ? 'block' : 'none' }}
        >
          {this.props.buttons}
          {process.env.REACT_APP_FORM_FOLD === 'true' ? null : (
            <span
              onClick={handleToggle}
              className={style.more}
              style={{
                display:
                  this.props.children && this.props.children.length > queryFieldsLimit
                    ? 'inline-block'
                    : 'none'
              }}
            >
              {!this.state.hidden
                ? intl.get('hzero.common.button.expand').d('展开')
                : intl.get('hzero.common.button.up').d('收起')}
              <img
                src={png}
                className={classNames(style.icon, this.state.hidden ? style.animate : '')}
                alt={
                  !this.state.hidden
                    ? intl.get('hzero.common.button.expand').d('展开')
                    : intl.get('hzero.common.button.up').d('收起')
                }
              />
            </span>
          )}
        </div>
      </div>
    );
  }
}
export default HlsForm;
