Swipe 轮播

```html
    <h2 class="item-title">Swip基础使用</h2>
      <swipe @start="start" @move="move" @change="change" :interval="5000">
        <swipe-item>
          <div :style="{'background': bgColor[0]}" class="item-bg">0</div>
        </swipe-item>
        <swipe-item>
          <div :style="{'background': bgColor[1]}" class="item-bg">1</div>
        </swipe-item>
        <swipe-item>
          <div :style="{'background': bgColor[2]}" class="item-bg">2</div>
        </swipe-item>
      </swipe>

      <h2 class="item-title">纵向滚动</h2>
      <swipe :vertical="true" style="height: 400px">
        <swipe-item v-for="key in count" :key="key" :style="{'background': bgColor[key-1]}">
          <div class="item-bg">{{ key-1 }}</div>
        </swipe-item>
      </swipe>

      <h2 class="item-title">定制indicators</h2>
      <swipe :index.sync="index">
        <swipe-item v-for="key in count" :key="key" :style="{'background': bgColor[key-1]}">
          <div class="item-bg">{{ key-1 }}</div>
        </swipe-item>
        <div v-for="key in count" slot="indicators" :key="key" :class="['indicators', {'active': key-1 === index}]"/>
      </swipe>
      
    this.count=3  
    this.bgColor = ['#5D98F6', '#1aad19', '#eebe41']     
```
