Field 输入框

```html
      <h-field v-model="number" label="金额"/>
      <h-field
        v-model="number" format type="number"
        clearable error
        required label="金额"/>
      <h-field
        v-model="name"
        clearable
        required label="姓名"/>
      <h-field
        v-model="age"
        :decimal="false"
        type="number"
        clearable error
        required label="年龄"/>
      <h-field
        v-model="phone" :left-icon="leftIcon"
        type="tel"
        required label="手机号"/>
      <h-field
        v-model="password"
        type="password"
        required label="密码">
        <i slot="left-icon" class="field-icon field-right-icon icon ion-close-circled"/>
      </h-field>
      <h-field
        v-model="address" :autosize="true"
        type="textarea"
        inputAlign="left"
        rows="1"
        error
        required label="通讯地址"/>
      <h-field
        v-model="homeAddress"
        :autosize="true"
        :word-limit="true" type="textarea" maxlength="50"
        inputAlign="left"
        clearable error
        required label="家庭地址"/>
```
|字段名称 |字段说明 |类型 |必填 |默认 |
| ----|------|-------|------|------|
|value|当前值|String|Y|-|
|type|输入类型|String|N|text|
|decimal|是否支持小数（type=number有效）|Boolean|N|false|
|proportion|label与value比例|Array|N|[1,2]|
|required|是否必填|Boolean|N|false|
|readonly|只读属性|Boolean|N|false|
|disabled|禁用属性|Boolean|N|false|
|itemHeight|字端默认高度|Number|N|45|
|label|输入框左侧文本|String|Y|-|
|leftIcon|左侧图标名称或图片链接|String|N|-|
|rightIcon|右侧图标名称或图片链接|String|N|-|
|clearable|是否启用清除图标，点击清除图标后会清空输入框|Boolean|false|-|
|clearTrigger|显示清除图标的时机，always 表示输入框不为空时展示，focus 表示输入框聚焦且不为空时展示|String|N|focus|
|format|是否启用金额千分位化（type=number有效）|Boolean|false|-|
|maxlength|输入的最大字符数|Number,String|false|-|
|inputAlign|输入框对齐方式，可选值为 center left|String|false|right|
|placeholder|输入框默认提示|String|N|请输入+label|
|showPlaceholder|是否显示placeholder|Boolean|N|true|
|error|必输校验后输入框标红|Boolean|N|false|
|autosize|是否自适应内容高度，只对 textarea 有效，可传入对象,如 { maxHeight: 100, minHeight: 50 }，单位为px|Boolean,Object|N|-|
|wordLimit|是否显示字数统计，需要设置maxlength属性|Boolean|N|false|

