/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-30 14:39:47
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-10-12 15:32:31
 * @Version: 1.0.0
 * @Description: 工具类
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
const getCustomizedProp = (layoutCode, tabCode, columnName, props) => {
  return props.filter(
    value =>
      value.columnName === columnName &&
      (!value.tabCode || value.tabCode === tabCode) &&
      (!value.layoutCode || value.layoutCode === layoutCode)
  );
};

const getCustomized = (layoutCode, tabCode, columnName, props) => {
  const customizedProp = getCustomizedProp(layoutCode, tabCode, columnName, props);
  return customizedProp.length > 0 ? customizedProp[0] : {};
};

const getHeaderExtrasProp = (layoutCode, tabCode, props) => {
  return props.filter(
    value =>
      (!value.tabCode || value.tabCode === tabCode) &&
      (!value.layoutCode || value.layoutCode === layoutCode)
  );
};

const getDataSetName = (config, tabCode) => {
  return config[tabCode].dataSetName || '';
};

const suppField = (num) => { // 补充显示
  return `${num < 10 ? `0`: ''}${num}`;
}

/**
 * 日期格式话
 * @param {*} type 日期类型
 * @param {*} time date类型
 * @returns 
 */
const dateFormat = (type, time) => { // 时间格式化 2019-09-08
  let year = time.getFullYear();
  let month = suppField(time.getMonth() + 1);
  let day = suppField(time.getDate());
  let hour = suppField(time.getHours());
  let minutes = suppField(time.getMinutes());
  let seconds = suppField(time.getSeconds());
  let dateDescription = `${year}-${month}-${day}`;
  let dateValue = `${year}-${month}-${day}`;
  if (['time', 'dateTime'].includes(type)) {
    dateDescription = `${year}-${month}-${day} ${hour}:${minutes}:${seconds}`;
    dateValue = dateDescription;

  } else if (type === 'month') { // 月
    dateDescription = `${year}-${month}`;
    dateValue = `${year}-${month}-01`;

  } else if (type === 'year') { // 年
    dateDescription = `${year}`;
    dateValue = `${year}-00-00`;

  } else if (type === 'week') { // 周
    const firstDayOfYear = new Date(year, 0, 1);  // 获取当年的第一天
    const pastDaysOfYear = (time - firstDayOfYear) / 86400000;  // 计算已经过去的天数
    const weekNum = Math.ceil((pastDaysOfYear + firstDayOfYear.getDay() + 1) / 7);  // 计算当前日期是第几周
    dateDescription = `${year}-${weekNum}周`;
  }
  return {
    value: dateValue,
    description: dateDescription
  }
};

/**
   * 判断平台
   * @return {String} 平台
   */
  const detectOS = () => {
    const ua = navigator.userAgent.toLowerCase()

    if (/MicroMessenger/i.test(ua)) {
      return 'weixin'
    } else if (/iPhone|iPad|iPod|iOS/i.test(ua)) {
      return 'ios'
    } else if (/Android/i.test(ua)) {
      return 'android'
    } else {
      return 'other'
    }
  };

  // 根据tabcode获取对应的表单值
const getFormValuesByTabCode = async (dataSets, tabCode) => {
  const formRef = dataSets[tabCode].instanceRef;
  if (formRef) {
    const values = await formRef.validate();
    return values;
  }
  return {
    allValues: {},
    formValues: {}
  }
}

// 根据tabcode获取对应的组件ref
const getRefByTabCode = (dataSets, tabCode) => {
  const instanceRef = dataSets[tabCode].instanceRef;
  return instanceRef;
}

const getOrganizationId = () => {
  return 0;
  // const globalState = getDvaApp()._store.getState();
  // const user = globalState.user || {};
  // switch (system) {
  //   case 'hls': // return getCurrentOrganizationId();
  //   case 'hcf':
  //     // return  0;
  //     return user?.currentUser.tenantId;
  //   default:
  //     break;
  // }
};

const getCurrentUser = () => {
  return {
    "id": 1,
    "loginName": "admin",
    "email": "admin@hzero.com",
    "organizationId": 0,
    "realName": "超级管理员",
    "phone": "18666666661",
    "internationalTelCode": "+86",
    "imageUrl": "http://hlsapp.hand-china.com/hls-file/public/hiam02/0/fd6ca1bdf3254e499b568f15cb8d3f51@WechatIMG775.jpg",
    "language": "zh_CN",
    "languageName": "简体中文",
    "timeZone": "GMT+8",
    "lastPasswordUpdatedAt": "2024-06-05 11:38:35",
    "countryId": 1,
    "countryName": "安道尔",
    "regionId": 0,
    "phoneCheckFlag": 1,
    "emailCheckFlag": 1,
    "passwordResetFlag": 1,
    "tenantName": "融租易",
    "tenantNum": "HLS",
    "dateFormat": "YYYY-MM-DD",
    "timeFormat": "HH:mm:ss",
    "dateTimeFormat": "YYYY-MM-DD HH:mm:ss",
    "changePasswordFlag": 0,
    "title": "融租易5.0",
    "logo": "http://leafdev.hand-china.com/hls-file/public/hpfm05/0/d21ff00430f146caa234a8e5ddde2320@融租易icon.png",
    "menuLayout": "inline",
    "menuLayoutTheme": "default",
    "roleMergeFlag": 0,
    "tenantId": 0,
    "currentRoleId": 1,
    "currentRoleCode": "role/organization/default/administrator",
    "currentRoleName": "租户管理员",
    "currentRoleLevel": "organization",
    "currentRoleLabels": [
        "TENANT_ADMIN"
    ],
    "favicon": "",
    "dataHierarchyFlag": 0,
    "recentAccessTenantList": []
};
};


/**
 * 判断角色层级是否是租户层级
 */
const isTenantRoleLevel = () => {
  const { currentRoleLevel } = getCurrentUser();
  return currentRoleLevel !== 'site';
}


/**
 * 获取页面布局保存数据
 */
const getLayoutSaveData = async (dynamicInfo) => {
  const saveDataSet = dynamicInfo.dataSetObject;
  const dataSets = {...saveDataSet};
  for (let key in dataSets) {
    if (dataSets.hasOwnProperty(key) && dataSets[key].tabType==='Form') { // 确保key是对象自身的属性
      const {instanceRef} = dataSets[key];
      if(instanceRef) {
        const values = await instanceRef.validate();
        dataSets[key].submitValues = values;
      }
    }
  }
  const {layoutCode, metaKeys, dataSetMap} = getDataSets(dynamicInfo, dataSets);
  return [{layoutCode, metaKeys, ...dataSetMap}];
  // save([{layoutCode, metaKeys, ...dataSetMap}]).then(res => {
  //   saveCallBack(res);
  // })
}

const getDataSets = (dynamicInfo, dataSetTree) => {
  const { layoutCode } = dynamicInfo.config;
  const metaKeys = { top: [] };
  const dataSetMap = {};
  const serverNames = {};
  const saveCheckUrls = {};
  const delChackUrls = {};
  Object.values(dataSetTree).forEach(config => {
    const { parentDataSetName, dataSetName, baseTable, parentTable, submitValues, savedCheckApi } = config;
    
    if (baseTable !== parentTable) { // 不是同一数据源
      if (parentDataSetName) {
        if (dataSetMap[parentDataSetName]) { // 存在值
          let currentVal = dataSetMap[parentDataSetName][0];
          currentVal[dataSetName] = submitValues ? [submitValues.allValues] : [];
          dataSetMap[parentDataSetName] = [currentVal];
        } else {
          dataSetMap[parentDataSetName] = [{
            [dataSetName]: submitValues ? [submitValues.allValues] : []
          }]
        }
        metaKeys[parentDataSetName].push(dataSetName);
        metaKeys[dataSetName] = [];
      } else {
        if (dataSetMap[dataSetName]) { // 存在值
          let currentVal = dataSetMap[dataSetName][0];
          currentVal = {...(submitValues ? submitValues.allValues : {}), ...currentVal};
          if (currentVal.childrenDs) {
            const childs = [...currentVal.childrenDs];
            delete currentVal.childrenDs;
            childs.forEach(item => {
              currentVal = {...currentVal, ...item};
            })
          }
          dataSetMap[dataSetName] = [currentVal];
        } else {
          dataSetMap[dataSetName] = submitValues ? [submitValues.allValues] : []
        }
        metaKeys.top.push(dataSetName);
        metaKeys[dataSetName] = [];
      }
    } else if (baseTable) { // 复用数据源
      if (dataSetMap[parentDataSetName]) {
        let currentVal = dataSetMap[parentDataSetName][0];
        dataSetMap[parentDataSetName] = [{...currentVal, ...(submitValues ? submitValues.formValues : {})}];
      } else {
        dataSetMap[parentDataSetName] = [{childrenDs: submitValues ? submitValues.formValues : {}}]
      }
    }
  });
  return {
    layoutCode, metaKeys, dataSetMap, serverNames, saveCheckUrls, delChackUrls 
  }
}

const reloadData = (dataSets, type = 'all') => {
  for (let key in dataSets) {
    if (dataSets.hasOwnProperty(key)) {
      const {instanceRef} = dataSets[key];
      if(instanceRef) {
        if (type === 'all') {
          if (dataSets[key].tabType==='Form') {
            instanceRef.loadData();
          } else if (dataSets[key].tabType==='Table') {
            instanceRef.refresh();
          }
        } else {
          if (type === 'Form' && dataSets[key].tabType==='Form') {
            instanceRef.loadData();
          }
          if (type === 'Table' && dataSets[key].tabType==='Table') {
            instanceRef.refresh();
          }
        }
      }
    }
  }

}

const getBindValue = (bindStr, record) => {
  const bindArr = bindStr.split('.');
  if (bindArr.length > 1) {
    return record[bindArr[0]] ? record[bindArr[0]][bindArr[1]] : record[bindArr[0]];
  } else {
    return record[bindArr[0]];
  }
}

const setBindValue = (bindStr, record, columnName) => {
  const bindField = bindStr.split('.');
  if (bindField.length > 1) {
    if (record[bindField[0]]) {
      record[bindField[0]][bindField[1]] = record[columnName];
    } else {
      record[bindField[0]] = {
        [bindField[1]]: record[columnName]
      };
    }
  } else {
    record[bindField[0]] = record[columnName];
  }
}


export { 
  getCustomizedProp, 
  getCustomized,
  getHeaderExtrasProp,
  getDataSetName,
  dateFormat,
  detectOS,
  getFormValuesByTabCode,
  getRefByTabCode,
  getOrganizationId, 
  getCurrentUser,
  isTenantRoleLevel,
  getLayoutSaveData,
  reloadData,
  getBindValue,
  setBindValue
};
