/*
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-07-30 09:41:54
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-09-19 16:16:19
 * @Version: 1.0.0
 * @Description: 表格列渲染
 * @Copyright: Copyright (c) 2021, Hand-RongJing
 */
import Vue from 'vue';
import {getBindValue} from '../../utils/utils'

const DTableTd = {
  components: {
  },
  props: {
    column: {
      type: Object,
      default: () => ({})
    },
    record: { // 数据
      type: Object,
      default: () => ({})
    },
    index: {
      type: Number,
      default: null,
    },
    columnName: {
      type: String,
      default: '',
    },
    tdRender: {
      type: Function,
      default: null
    },
    typeDisplay: {
      type: String,
      default: 'Field'
    }
  },
  data () {
    return {
    }
  },
  methods: {
    columnValue() {
      if (this.column.bind) {
        return getBindValue(this.column.bind, this.record)
      } else {
        if (['Lov', 'Select'].includes(this.typeDisplay)) {
          return this.record[`${this.columnName}Name`] || this.record[`${this.columnName}N`] || this.record[this.columnName];
        } else {
          return this.record[this.columnName];
        }
      }
    }
  },
  // 为了弥补缺少的实例
  // 提供第二个参数作为上下文
  render: function (h, context) {
    return this.tdRender ? 
      this.tdRender(this.record, this.index) : 
      <span>{this.$slots.default || (this.columnValue() || '--')}</span>
  }
};
 
export default DTableTd;