// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'

// import FastClick from 'fastclick'
import axios from 'axios'
import App from './App'
import router from './router/index'

// import flexible from './common/ydui.flexible'

import {componentInstall, hlsPopup, directives, filter, prototype} from '../packages/index'

import component from './components/index'

/**
 * http
 */
import {post, get} from './scripts/hlsHttp'

/** 全局函数hlsUtil**/

import hlsUtil from './scripts/hlsUtil'

Vue.use(prototype)
Vue.use(component)

/** end**/

if (process.env.CONFIG_ENV === 'uat') {
  const VConsole = require('vconsole')
  new VConsole() // eslint-disable-line
}
Vue.use(componentInstall)
// Vue.use(appStyle)
// Vue.use(flexible)

Vue.use(directives)

Vue.use(filter)

Vue.prototype.hlsPopup = window.hlsPopup = hlsPopup
Vue.prototype.$devicePixelRatio = 2
Vue.prototype.axios = window.axios = axios

Vue.prototype.$post = post
Vue.prototype.$get = get
let hlsHttp = {
  get: get,
  post: post,
}

Vue.prototype.hlsHttp = window.hlsHttp = hlsHttp

Vue.prototype.hlsUtil = window.hlsUtil = hlsUtil

/**
 * 全局返回上一页面
 * @param index
 */
let routeGo = function (index) {
  if (!index) {
    index = -1
  }
  this.$router.go(index)
}
Vue.prototype.$routeGo = routeGo

let hlsExit = function () {
}
Vue.prototype.$hlsExit = hlsExit

// FastClick.attach(document.body)

Vue.config.productionTip = false

/* eslint-disable no-new */
new Vue({
  data () {
    return {
      pathList: [],
      transitionName: null,
    }
  },
  router,
  watch: { // 监听路由变化
    $route (to, from) {
      document.body.scrollTop = 0
      document.documentElement.scrollTop = 0
    },
  },
  render: h => h(App),
}).$mount('#app-box')
