h-radio 单选框组建

```html
    
<template>
  <h-view>
    <h-content>
      <list-item>
        <item>
          <section slot="name">注册国家</section>
          <radio-group slot="content" v-model="radioValue">
            <h-radio :checked="true" name="China" title="中国"/>
            <h-radio :disable="true" name="Japan" title="日本"/>
            <h-radio name="Other" title="其他"/>
          </radio-group>
        </item>
      </list-item>
      <radio-group v-model="radioValue">
        <h-radio name="China" title="中国"/>
        <h-radio :checked="true" :disable="true" name="Japan" title="日本"/>
        <h-radio name="Other" title="其他"/>
      </radio-group>
    </h-content>
  </h-view>
</template>

<script>
export default {
  name: 'RadioTest',
  data () {
    return {
      radioValue: 'Japan',
    }
  },
  watch: {
    radioValue (value) {
      console.log(value)
    },
  },
  methods: {},
}
</script>

<style scoped lang="less">
  .hls-list-item{
    .hls-item{
      .radio-group{
        display: flex;
        .h-radio{
          margin-right: 5px;
        }
      }
    }
  }
</style>
 ```     

单选框组建必须配合radio-group使用表示一组

style

@radio-box-bg checkbox选中是的背景颜色

v-model 绑定radio的选中返回的name值

disable 是否只读 true/false

checked 是否默认选中

name radio选中时返回的value

title radio对应的value描述
 
@radioClick 点击radio的触发函数 返回当前选中的value值

