# hls-easy-ui 车租易Vue组件库


### 底部弹出菜单 插件形式调用

```html
showActionSheet() {
        hlsPopup.showActionSheet({
          titleText: '请选择照片',
          buttonArray: ['拍照', '从相册取'],
          callback: (index) => {
            alert(index);
          }
        })
    }

showActionSheetButton() {
        hlsPopup.showActionSheet({
          titleText: '照片',
          buttonArray: [{text: '拍照', type: 'warn'}, {text: '从相册取', type: 'primary'}],
          callback: (index) => {
            alert(index);
          }
        });
}
```

### bottom-tab 固定与屏幕底部按钮     
```html
<h-view>
    <bottom-tab :show-divider="true">
      <tab-button cusClass="button-exit" @click.native="showConfirm"><img
        src="../assets/image/myInfo/loginout@2x.png">退出
      </tab-button>
      <tab-button :disable="true" @click.native="showSuccess">登陆</tab-button>
    </bottom-tab>
</h-view>    
``` 

### checkBox 配合 ListItem组件调用

```html
    <list-item>
      <item :show-arrow="true">
         <img slot="left-icon" src="../assets/myInfo/version@2x.png" class="left-icon">
         <div slot="name">检查更新</div>
         <check-box slot="content" v-model="savePhoto" @checkClick="savePhotoFun"></check-box>
      </item>
    </list-item>
      
      
    export default {
       data() {
         return {
           savePhoto: new Boolean(window.localStorage.savePhoto) || false,
         }
       },
       methods: {
         savePhotoFun(value) {
           this.savePhoto = value;
           window.localStorage.setItem('savePhoto', value);
         }
       }
    }
      
```

### Notify 通知提醒 插件和组件形式调用

```html
    <h2 class="item-title">notify</h2>
    <div class="local-region">
      <notify v-model="show1" content="提示内容"/>
      <notify v-model="show2" :time="3000" position="bottom" content="提示内容"/>
    </div>
    
    <h2 class="item-title">notify标签用法 (通常在局部显示时使用)</h2>
    <h-button class="button-class" type="rimless" shadow @click.native="showNotifyAtTop">Notify (top)</h-button>
    <h-button class="button-class" type="rimless" shadow @click.native="showNotifyAtBottom">Notify (bottom)</h-button>
    
    
    // 标签用法
    showNotifyAtTop() {
      if (this.show1) return
         this.show1 = true
      },
    showNotifyAtBottom() {
      if (this.show2) return
         this.show2 = true
      },
    // 插件用法
     showNotify(ops = {}) {
       hlsPopup.showNotify({
              content: ops.content,
              position: ops.position,
              time: ops.time
            })
          },
          handleNotify() {
            this.showNotify({
              content: '提示内容',
              position: 'top',
              time: 2000
            })
          },
      
```

### h-button 按钮

```html
<h2 class="item-title">按钮类型</h2>
      <h-button class="button-class" type="rimless">rimless 按钮</h-button>
      <h-button class="button-class" type="default">default 按钮</h-button>
      <h-button class="button-class" type="primary">primary 按钮</h-button>
      <h-button class="button-class" type="safety">safety 按钮</h-button>
      <h-button class="button-class" type="warning">warning 按钮</h-button>
      <h-button class="button-class" type="danger">danger 按钮</h-button>

      <h2 class="item-title">按钮尺寸</h2>
      <h-button class="button-class" size="mini">mini 按钮</h-button>
      <h-button class="button-class" size="small">small 按钮</h-button>
      <h-button class="button-class" size="normal">normal 按钮</h-button>
      <h-button class="button-class" size="large">large 按钮</h-button>
      <h-button class="button-class" size="huge">huge 按钮</h-button>

      <h2 class="item-title">自定义圆角 (直接通过class设置)</h2>
      <h-button class="button-class radius-small">rimless 按钮</h-button>
      <h-button class="button-class radius-normal">default 按钮</h-button>
      <h-button class="button-class radius-large">primary 按钮</h-button>

      <h2 class="item-title">默认点击效果</h2>
      <h-button class="button-class radius-small" type="rimless">基础按钮(无边框)</h-button>
      <h-button class="button-class radius-small" type="rimless" shadow>基础按钮(无边框、有阴影效果)</h-button>
      <h-button class="button-class radius-small purple">基础按钮(有背景色)</h-button>

      <h2 class="item-title">禁用效果</h2>
      <h-button class="button-class radius-small" disabled>基础按钮(禁用)</h-button>
      
```

### h-content 内容区域

```html
<h-view>
    <h-content class="has-header">
      <div>内容</div>
    </h-content>
<h-view>    
      
```

### h-header 头部导航

```html
 
    <h-header class="bar-custom">
      <div slot="left" class="h-header-btn" @click="$routeGo()">
        <i class="ion-ios-arrow-back"/>
      </div>
      <div slot="center">意见反馈</div>
      <div slot="right" class="h-header-btn">测试</div>
    </h-header>
    
```

### h-view 页面部分

```html
<h-view>
    <h-header>
    </h-header>
    <h-content class="has-header">
    </h-content>
</h-view> 
      
```

### item-option 滑动删除

```html
<template>
  <div>
    <!--
    slot="buttons" 滑动按钮的插槽
    option-button 滑动的按钮
                 type 按钮的颜色
                 text 按钮文字
    -->
    <item-option  v-for="(color,index) in colors" :key="index"
                       class="mySlider">
              <div>{{color.name}}</div>
              <div>{{color.hex}}</div>
              <div slot="buttons">
                <option-button type="default" text="默认" @click.native="deleteFun"></option-button>
                <option-button type="primary" text="编辑" @click.native="deleteFun"></option-button>
                <option-button type="warn" text="删除" @click.native="deleteFun"></option-button>
              </div>
            </item-option>
  </div>
</template>

<script>
  export default {
    data(){
      return{
        colors: [ { name: 'Yellow', hex: '#f4d03f' }, { name: 'Green', hex: '#229954' }, { name: 'Purple', hex: '#9b59b6' } ],
      }
    },
    methods:{
      //e为该元素在数组的下标
      deleteFun(e){
        console.log(e);
      }
    }
  }
</script>

<style scoped lang="less" type="text/less">
  //修改子组件样式的方法，非默认样式可以直接加上，默认样式需要以important覆盖
  //item高度
  .list{
    height:150px!important;
  }
</style>
```

### list-item 列表

```html
      <list-item :item-height="50">
        <item>
          <img slot="left-icon" src="../assets/myInfo/version@2x.png" class="left-icon">
          <div slot="name">检查更新</div>
          <div slot="content">检查更新</div>
        </item>
        <item>
          <!--<img slot="left" src="../assets/myInfo/speak@2x.png" class="left-icon">-->
          <div slot="name">字数测试</div>
          <div slot="content">我是一段很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长很长的文字</div>
        </item>
        <item :show-arrow="true">
          <!--<img slot="left" src="../assets/myInfo/robot@2x.png" class="left-icon">-->
          <div slot="name">客户名称</div>
          <input slot="content" type="text" placeholder="请输入" v-model="bp_name"/>
        </item>
        <item :show-arrow="true">
          <img slot="left-icon" src="../assets/myInfo/version@2x.png" class="left-icon">
          <div slot="name">检查更新</div>
          <check-box slot="content" v-model="savePhoto" @checkClick="savePhotoFun"></check-box>
        </item>
      </list-item>
```


### 数字键盘 插件和组件调用

```html
      <list-item :item-height="90">
        <item>
          <div slot="name">数字键盘</div>
          <input slot="right" type="number" placeholder="输入" readonly v-model="value" @click="keyboradShow">
        </item>
      </list-item>
      
     <number-keyboard
       :show="true"
       title="数字键盘"
       extra-key="."
       @input="onInput"
       @delete="onDelete"/>     
      
      
      keyboradShow() {
        let vm = this;
        hlsPopup.showNumberKeyborad({
          title: '数字键盘',
          keyDown: (text) => {
            vm.onInput(text);
          },
          keyDelete: () => {
            vm.onDelete()
          },
        })
      },      
```

### scroll 滚动组件

```html
基于better-scroll

    <scroll
      ref="scroll"
      :autoUpdate="true"
      :pullUp="true"
      class="has-header"
      @pullingUp="loadMore">
      
      滚动内容
      </scroll>
   
```

### select下拉框 插件形式调用

```html
      <h-button class="button-class" type="primary" @click.native="selectListOne">selectList 普通下拉框</h-button>
      <h-button class="button-class" type="primary" @click.native="selectListTwo">selectList 二级联动</h-button>
      <h-button class="button-class" type="primary" @click.native="selectList">selectList 三级联动</h-button>
      
      selectListOne() {
        var bp_class_list = [
          {
            "code": "NP",
            "code_name": "个人"
          }, {
            "code": "NP1",
            "code_name": "个人1"
          }, {
            "code": "NP2",
            "code_name": "个人2"
          }
        ];
        hlsPopup.selectList({
          list: bp_class_list,
          code: 'bp_type',
          object: {},
          returnItem: function (index, obj, child) {
            console.log('index:' + index + ',object:' + vum.toJson(obj) + ',:child' + vum.toJson(child))
          }
        })
      },
      selectListTwo() {
        var bp_class_list = [
          {
            "code": "NP",
            "code_name": "个人"
          }, {
            "code": "NP1",
            "code_name": "个人1"
          }, {
            "code": "NP2",
            "code_name": "个人2"
          }, {
            "code": "NP3",
            "code_name": "个人3",
            "parent": 'NP',
          }, {
            "code": "NP4",
            "code_name": "个人4",
            "parent": 'NP1',
          }, {
            "code": "NP5",
            "code_name": "个人5",
            "parent": 'NP2',
          }
        ];
        hlsPopup.selectList({
          list: bp_class_list,
          code: 'bp_type',
          object: {},
          returnItem: function (index, obj, child) {
            console.log('index:' + index + ',object:' + vum.toJson(obj) + ',:child' + vum.toJson(child))
          }
        })
      },
      selectList() {
        var bp_class_list = [
          {
            "code": "NP",
            "code_name": "个人"
          }, {
            "code": "NP1",
            "code_name": "个人1"
          }, {
            "code": "NP2",
            "code_name": "个人2"
          }, {
            "code": "NP3",
            "code_name": "个人3",
            "parent": 'NP',
          }, {
            "code": "NP4",
            "code_name": "个人4",
            "parent": 'NP',
          }, {
            "code": "NP5",
            "code_name": "个人5",
            "parent": 'NP2',
          }, {
            "code": "NP6",
            "code_name": "个人6",
            "parent": 'NP3'
          }, {
            "code": "NP7",
            "code_name": "个人7",
            "parent": 'NP4'
          },
          {
            "code": "NP8",
            "code_name": "个人8",
            "parent": 'NP1'
          }
        ];
        hlsPopup.selectList({
          list: bp_class_list,
          code: 'bp_type',
          object: {},
          returnItem: function (index, obj, child) {
            console.log('index:' + index + ',object:' + vum.toJson(obj) + ',:child' + vum.toJson(child))
          }
        })
      },      
```

### showBigPicture查看大图 插件形式调用
   
   ```html
         <h-button class="button-class" type="primary" @click.native="showBigPicture">showBigPicture</h-button>
   
         showBigPicture() {
           hlsPopup.showBigPicture({
             imgUrl: 'http://hlsapp.hand-china.com/hls_file/2018/05/F1B6D85E409A4714A8540504B2D133AD'
           })
         },      
                   
   ```

### Spin 旋转提示

```html
      <h2 class="item-title">Spin-CSS</h2>
      <div class="spin-container">
        <spin size="40px" color="#ccc"/>
        <spin size="60px" color="#999"/>
        <spin size="80px" color="#666"/>
        <spin size="100px" color="#333"/>
      </div>

      <h2 class="item-title">SVG</h2>
      <div class="spin-container">
        <!-- 颜色要通过修改svg来实现，无法通过属性修改 -->
        <spin :svg-src="svgSrc" size="80px"/>
        <spin :svg-src="svgSrc" size="100px"/>
        <spin :svg-src="svgSrc" size="120px"/>
        <spin :svg-src="svgSrc" size="140px"/>
      </div>
      
   import svg from '@/assets/loading/rolling.svg'
 
   export default {
     data() {
       return {
           svgSrc: svg,
       }
     },         
                
```

### s-tab 切换    
```html
      <div class="local-region">
        <s-tab @tabClick="stabClick" :show-divider="true" has-border="true">
          <tab-item>测试</tab-item>
          <tab-item>你好</tab-item>
          <tab-item>再见</tab-item>
          <tab-item>按钮</tab-item>
        </s-tab>

        <s-tab @tabClick="stabClick" cusClass='class' :default-active="2">
          <tab-item><img src="../assets/image/myInfo/about@2x.png"></tab-item>
          <tab-item><img src="../assets/image/myInfo/version@2x.png"></tab-item>
          <tab-item><img src="../assets/image/myInfo/setting@2x.png"></tab-item>
          <tab-item><img src="../assets/image/myInfo/speak@2x.png"></tab-item>
        </s-tab>
      </div>
``` 


### Swipe 轮播

```html
    <h2 class="item-title">Swip基础使用</h2>
      <swipe @start="start" @move="move" @change="change" :interval="5000">
        <swipe-item>
          <div :style="{'background': bgColor[0]}" class="item-bg">0</div>
        </swipe-item>
        <swipe-item>
          <div :style="{'background': bgColor[1]}" class="item-bg">1</div>
        </swipe-item>
        <swipe-item>
          <div :style="{'background': bgColor[2]}" class="item-bg">2</div>
        </swipe-item>
      </swipe>

      <h2 class="item-title">纵向滚动</h2>
      <swipe :vertical="true" style="height: 400px">
        <swipe-item v-for="key in count" :key="key" :style="{'background': bgColor[key-1]}">
          <div class="item-bg">{{ key-1 }}</div>
        </swipe-item>
      </swipe>

      <h2 class="item-title">定制indicators</h2>
      <swipe :index.sync="index">
        <swipe-item v-for="key in count" :key="key" :style="{'background': bgColor[key-1]}">
          <div class="item-bg">{{ key-1 }}</div>
        </swipe-item>
        <div v-for="key in count" slot="indicators" :key="key" :class="['indicators', {'active': key-1 === index}]"/>
      </swipe>
      
    this.count=3  
    this.bgColor = ['#5D98F6', '#1aad19', '#eebe41']     
```

### TopTip 顶部消息提示

```html
<h2 class="item-title">top-tip</h2>
  <div class="local-region">
    <top-tip v-model="show" entry-direction="down" content="顶部消息提示内容"/>
     参考文案
  </div>

<h-button class="button-class" type="rimless" shadow @click.native="showTopTip">TopTip</h-button>  

    showTopTip () {
      if (this.show) return
      this.show = true
    },
  
```

### h-progress(进度条) h-range(滑块)

```html
      <h-range
        :decimal="decimal" v-model="rangeValue" :min="min" :max="max"
        :step="step" :disabled="disabled" :disabled-opacity="disabledOpacity" :range-bar-height="rangeBarHeight"
        :range-handle-height="rangeHandleHeight" @change="change" @touchstart="touchStart" @touchend="touchEnd"/>

      <h-progress :percent="70"/>
```

### Note 
 hls-easy-ui#0.0.6
   [时间组件 Field](/packages/components/Field/README.md)
    
   [时间组件 DateField](/packages/components/DataField/README.md)
 
   [下拉框组建 SelectField](/packages/components/Select/README.md)
   
   [添加进度条 h-progress](/packages/components/Progress/README.md)
      
   [添加滑块 h-range](/packages/components/Range/README.md)

 hls-easy-ui#0.0.5
 
   [添加金额输入框 currency-input](/packages/components/CurrencyInput/README.md)
    
   [添加动态配置组件 h-layout](/packages/components/HLayout/README.md)
   
 hls-easy-ui#0.0.4
  
   [添加懒加载组件](https://github.com/hilongjw/vue-lazyload)
 
   [添加文件选择组件 h-file](/packages/components/HFile/README.md)
   
   [添加单选框组件 h-radio](/packages/components/Radio/README.md)
   
   [添加checkBox组件](/packages/components/CheckBox/README.md)
   
   [修改原有的check-box组件名为h-switch](/packages/components/Switch/README.md)

 hls-easy-ui#0.0.3 
 
    添加ios下content的has-footer样式用于content高度在100%是滑动不到底部的问题
    修复 s-tab分割线以及活跃状态下底部边线的样式
