<!--
 * @Author: zong.wang01@hand-china.com
 * @Date: 2024-08-16 14:40:38
 * @LastEditors: zong.wang01@hand-china.com
 * @LastEditTime: 2024-08-22 14:23:43
 * @Version: 1.0.0
 * @Description: 
 * @Copyright: Copyright (c) 2021, Hand-RongJing
-->
# 低代码组件说明

### 需要添加的依赖
  "less-loader": "5.0.0",
  "babel-plugin-syntax-jsx": "^6.18.0",
  "babel-plugin-transform-es2015-modules-commonjs": "^6.26.2",
  "babel-plugin-transform-vue-jsx": "^3.7.0",
  "babel-preset-vue": "^2.0.2",
  "better-scroll": "1.15.1",
  "lodash": "^4.17.21",
  "vant": "^2.13.2",
  "vue": "^2.5.2",
  "vue-fragment": "^1.6.0",

### .babelrc增加jsx的编译（针对vue2）
"plugins": ["transform-runtime", "transform-vue-jsx"]

### 动态组件暴露出的内容
``` javascript
{
  Dynamic, // 动态组件
  DAttachment, // 动态附件组件
  DUtils // 相关utils
}
```
以下对上面的内容一一说明
#### 【 Dynamic 】动态组件
``` html
<Dynamic 
  layoutCode="CN001"
  :showTitle="false"
  :componentRenderers="componentRenderers"
  :configLoadHandle="configLoadHandle"
  :dataLoadHandle="dataLoadHandle"
  :layoutButtons="layoutButtons"
  ref="dynamicRef"
/>
```
###### API
**props**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | -----: |
| layoutCode | 动态页面编码 | String | - |
| showTitle |   是否显示标题   | Boolean | true |
| needBack  |   显示标题返回键   | Boolean | true |
| componentRenderers  |   组件渲染   | Array | [] |
| headerButtons  |   页面需要额外渲染的按钮   | Array | [] |
| layoutButtons  |   页面整体布局按钮的方法(布局按钮除了默认的save之外，其他的按钮需要配置了方法才会显示)   | Array | [] |
| componentButtons  |   组件按钮方法   | Array | [] |
| staticLayoutTabs  |   静态布局内容   | Array | [] |
| configLoadHandle  |   页面配置加载回调   | Function | (config) => {} |
| dataLoadHandle  |   组件数据加载成功后的回调   | Function | (data, tabcode) => {} |

**Events**
| 事件名   | 说明 |   回调参数 |
| :---- | :--- | :---: |
| goBack | 页面返回方法 | - |

**componentRenderers**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | :----- |
| tabCode | 组件编码 | String | - |
| columnName |   字段名   | String | - |
| renderer  |   渲染方法<br/>表格时，方法回调参数`record`(表格这一行的数据)，`index`(这一行的下标)<br/>表单时，方法回调参数`fileConfig`(该字段的配置信息), `getData`(获取表单数据的方法)   | function | 表格：(record, index) => {}<br/>表单：(fieldConfig, getData) => {} |
| formRenderer  |   表格类型下，编辑状态下的渲染(参数同renderer方法的表单)   | function | (fieldConfig, getData) => {} |
``` javascript
[
  {
    tabCode: 'G_RESULT',
    columnName: 'chanceName',
    renderer: (record, index) => {
      return <span style="color: #3789ff" onClick={() => this.toDetail(record)}>{record.chanceName} <van-icon name="arrow" /></span>
    },
    formRenderer: (fileConfig, getData) => {
      const record = getData ? getData() : {};
      return <span>{record.name}</span>
    },
  },
]
```

**headerButtons**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | :----- |
| name | 按钮编码 | String | - |
| description |   按钮描述    | String | - |
| clickFunction  |   点击方法   | function | - |
``` javascript
[
  {
    name: 'copy',
    description: '复制',
    clickFunction: () => {}
  },
]
```

**layoutButtons**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | :----- |
| name | 按钮编码 | String | - |
| clickFunction  |   点击方法   | function | - |
``` javascript
[
  {
    name: 'save',
    clickFunction: () => {}
  },
]
```

**componentButtons**
参数说明同【layoutButtons】
``` javascript
[
  {
    name: 'save',
    clickFunction: () => {}
  },
]
```

**staticLayoutTabs**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | :----- |
| tabCode | 静态布局编码 | String | - |
| component  |   渲染内容    | function | - |
```javascript
[
  {
    tabCode: 'F_STATIC',
    component: () => {}
  }
]
```

**configLoadHandle**
页面配置信息回调方法中的config字段说明如下：
| 字段   | 说明 |
| :---- | :--- |
| layoutCode | 动态页面编码 |
| config  |   页面配置信息   |
| dataSetObject  |   页面datasetTree的转换，方便快速找出datasetname。该数据里边包含了form和table的ref实例，可以通过实例调用表单和表格的相关方法   |
| queryParams  |   页面的路由和url参数合集  |
| EventBus  | 动态组件的监听实例  |

**dataLoadHandle**
表格或表单数据查询回调：
| 字段   | 说明 |
| :---- | :--- |
| data | 接口返回的数据 |
| tabcode  |   组件编码   |


#### 【 DAttachment 】动态组件-附件组件
```javascript
// jsx写法
<DAttachment 
  isNew={record._status === 'create'}
  attachmentUuid={record.attachmentUuid}
  bucketName="spfm-comp"
  canEdit={fileConfig.readOnly}
  onGetUuidSuccess={this.getUuidSuccess} 
  onUploadSuccess={this.uploadCallBack}
  onLoadAttachments={this.getAttachments}
/>
```
**props**
| 参数   | 说明 |   类型 |  默认值 |
| :---- | :--- | :---: | :----- |
| isNew | 是否新建 | Boolean | true |
| attachmentUuid |   附件uuid   | String | - |
| bucketName  |   附件上传的模块名   | String | - |
| canEdit  |   是否可编辑   | Boolean | false |

**Events**
| 事件名   | 说明 |   回调参数 |
| :---- | :--- | :--- |
| getUuidSuccess | 组件内获取uuid之后的回调(仅新建状态下触发) | uuid |
| uploadSuccess | 附件上传成功后的回调 | file: 上传的文件<br/>fileList: 所有的附件 |
| loadAttachments | 获取所有的附件 | fileList: 所有的附件 |

#### 【 DUtils 】动态组件工具类
| 事件名   | 说明 |   参数 | 返回 ｜
| :---- | :--- | :--- | :--- |
| getFormValuesByTabCode | 通过tabcode获取表单字段值 | `datasets`: 取页面配置信息回调configLoadHandle中的dataSetObject<br/>`tabcode`: 组件tabcode值 | 表单当前的记录 |
| getRefByTabCode | 通过tabcode获取组件实例 | 参数同上 | tabcode对应的组件实例 |

**表单实例方法 - 通过ref调用**
| 事件名   | 说明 |   参数 | 返回 ｜
| :---- | :--- | :--- | :--- |
| getFieldsValue | 获取表单值 | names: Array(字段名数组，可为空，为空时查所有) | 返回names指定的字段值，names为空时返回表单所有字段值 |
| validate | 表单校验 | - | 校验成功后返回表单数据{allValues: '表单的所有数据，包含id等信息', formValues: '纯表单字段值，不包含id、token等信息'} |
| reset | 表单重置 | - | - |
| setFieldsValue | 设置表单值 | fields:Object | - |

**表格实例方法 - 通过ref调用**
| 事件名   | 说明 |   参数 | 返回 ｜
| :---- | :--- | :--- | :--- |
| refresh | 表格数据重新加载 | - | - |
| getList | 表格加载下一页 | - | - |