# HlsGridBox标签

说明：以下属性会举例一些常用的

### 一般属性：

| 属性名 | 类型 |
| :--- | :--- |
| HlsGridBox | String |
| title | String |
| width | String |
| height | String |
| hlsgridboxbody | String |
| hlsGridClass | String |
| hlsGridId | String |
| ContextPath | String |
| hlsBtnType | String |
| queryId | String |
| queryPlaceholder | String |
| ControllerName | String |
| viewModelName | String |
| dataSourceId | String |
| fildName | String |
| custom1Image | String |
| custom2Image | String |
| custom3Image | String |
| custom4Image | String |
| custom1Title | String |
| cuetom2Title | String |
| custom3Title | String |
| custom4Title | String |

### 字标签hlsGrid

说明：hlsGrid的子标签请参照Grid使用说明

### 一般常用属性：

提示：hlsGrid的使用请参照Grid的使用说明

| 属性 | 类型 |
| :--- | :--- |
| id |  |
| dataSource |  |
| hlsBtnType |  |
| editable |  |
| height |  |
| AutoResize |  |
| ResizeAble |  |
| navigatable |  |
| localte |  |



### 用法：

提示：因为单独属性不能显示，这里先介绍一些写法，会在写法的最后给出图片展示

##### 1.hlsGridId

说明：要和子标签hlsGrid的id保持一致

```html
  <h:hlsGridBox hlsGridId="grid">
        <h:hlsGrid id="grid" dataSource="gridDataSource"  >
        </h:hlsGrid>
    </h:hlsGridBox>

```

##### 2.hlsBtnType

说明：hlsBtnType有几种形式：add,delete,query,save,upload。可以都写上但不可以重复

```html
 <h:hlsGridBox hlsGridId="grid" hlsBtnType="add,save,query" >
        <h:hlsGrid id="grid" dataSource="gridDataSource"  hlsBtnType="DELETE" >
        </h:hlsGrid>
 </h:hlsGridBox>
```

##### 3.title

说明：显示在表格上面的标题

```html
<h:hlsGridBox hlsGridId="grid" hlsBtnType="add,save,query"  title="任务维护" >
        <h:hlsGrid id="grid" dataSource="gridDataSource"  hlsBtnType="DELETE">
        </h:hlsGrid>
</h:hlsGridBox>
```

##### 4.queryId

说明：查询事件

```html
  <h:hlsGridBox hlsGridId="grid" hlsBtnType="add,save,query"  title="任务维护" queryId="taskDetailQuery">
        <h:hlsGrid id="grid" dataSource="gridDataSource"  hlsBtnType="DELETE" >
        </h:hlsGrid>
  </h:hlsGridBox>
  
   <script>
        $('#taskDetailQuery').keydown(function (e) {
            if (e.keyCode == 13) {
                e.target.blur();
                viewModel.queryFunction(e);
            }
        });
    </script>
```

##### 5.viewModelName

说明：数据对象渲染

```html
  <h:hlsGridBox hlsGridId="grid" hlsBtnType="add,save,query"  title="任务维护" queryId="taskDetailQuery"  viewModelName="viewModel.data">
        <h:hlsGrid id="grid" dataSource="gridDataSource"  hlsBtnType="DELETE" >
        </h:hlsGrid>
  </h:hlsGridBox>
  
  <script>
      var viewModel = kendo.observable({
            isEnabled: true,
            data: {
            },
            queryFunction:function(e){
                  $('#grid').data('kendoGrid').dataSource.page(1);
            },
      });
</script>
```

##### 6.dataSourceId

说明：数据源，和子标签hlsGrid中的数据源一致

```html
<h:hlsGridBox hlsGridId="grid" hlsBtnType="add,save,query"  title="任务维护" queryId="taskDetailQuery"  viewModelName="viewModel.data" dataSourceId="gridDataSource">
        <h:hlsGrid id="grid" dataSource="gridDataSource"  hlsBtnType="DELETE" >
        </h:hlsGrid>
</h:hlsGridBox>

<script>
   $("#grid").kendoGrid({
      dataSource:[
      {description:"日结",enabledFlag:"Y",jobClassName:"hls.core.hls.job.hlsJobTest",objectVersionNumber:2,taskCode:"EXAMPLE_1",taskName:"任务1"},
      {description:"周结",enabledFlag:"Y",jobClassName:"2",objectVersionNumber:2,taskCode:"EXAMPLE_2",taskName:"任务2"},
      {description:"月结",enabledFlag:"Y",jobClassName:"3",objectVersionNumber:2,taskCode:"EXAMPLE_3",taskName:"任务3"}
      ]
   })
</script>
```

图片展示：

![](/assets/1303.png)

