# dataSource标签

数据源组件

```xml
<h:dataSource id="gridDataSource" batch="true" pageSize="10" serverPaging="true" error="requestError"> 
  <h:transport parameterMap="parameterMap"> 
    <h:read url="${base.contextPath}/sys/resource/query" type="POST" dataType="json"/>  
    <h:create url="${base.contextPath}/sys/resource/submit" type="POST" contentType="application/json"/>  
    <h:update url="${base.contextPath}/sys/resource/submit" type="POST" contentType="application/json"/>  
    <h:destroy url="${base.contextPath}/sys/resource/remove" type="POST" contentType="application/json"/> 
  </h:transport>  
  <h:schema data="rows" total="total" errors="schemaError"> 
    <h:model id="resourceId" editable="dsEditable"> 
      <h:fields> 
        <h:item name="loginRequire" defaultValue="Y" type="boolean" checkedValue="Y" uncheckedValue="N"/>  
        <h:item name="accessCheck" defaultValue="Y" type="boolean" checkedValue="Y" uncheckedValue="N"/>  
        <h:item name="type" defaultValue=""/>  
        <h:item name="url"> 
          <h:validation required="true"/> 
        </h:item>  
        <h:item name="name"> 
          <h:validation required="true"/> 
        </h:item> 
      </h:fields> 
    </h:model> 
  </h:schema> 
</h:dataSource>
```

### **主要属性**

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| data | Array & String | 数据源 |
| autoSync | Boolean | 自动同步 |
| batch | Boolean | 批处理 |
| page | Integer | 每页显示大小 |
| pageSize | Integer | 提供每页显示的大小选择 |
| serverAggregates | Boolean | 为true数据源将聚合远程计算 |
| serverFiltering | Boolean | 为true将过滤远程数据 |
| serverGrouping | Boolean | 为true将远程数据分组 |
| serverPaging | Boolean | 为true将远程数据分页 |
| serverSorting | Boolean | 为true将远程数据排序 |
| type | String | 类型 |
| change | Function | 改变事件 |
| error | Function | 错误事件 |
| push | Function | 接受数据源推送式通知 |
| requestEnd | Function | 请求结束调用事件 |
| requestStart | Function | 请求开始时调用事件 |
| sync | Function | 自动同步改变的数据 |

> **提示:** 属性用法请参考kendoui API文档 [http://docs.telerik.com/kendo-ui/api/javascript/data/datasource](http://docs.telerik.com/kendo-ui/api/javascript/data/datasource)

### **主要子节点**

* transport
* schema
* sort

### **transport**

服务端交互配置

#### **transport属性**

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| parameterMap | Function | 将请求数据改为远程接受的数据格式 |
| push | Function | 数据初始化时设置为推送式通知 |

```xml
<h:dataSource id="gridDataSource" > 
  <h:transport parameterMap="parameterMap"> 
    ...
  </h:transport>
</h:dataSource>
```

#### **transport子节点**

主要有以下几种节点类型

* read
* create
* update
* destroy

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| cache | Boolean | 设置为true将数据缓存住 |
| contentType | String | 发送到服务器的内容的http的头 |
| data | Object \| Function | 发送到远程服务的附加参数 |
| dataType | String | 服务器期望的返回类型 |
| type | String | 请求类型 |
| url | String \| Function | 请求地址 |

```xml
  <h:transport parameterMap="parameterMap"> 
    <h:read url="${base.contextPath}/sys/resource/query" type="POST" dataType="json"/>  
    <h:create url="${base.contextPath}/sys/resource/submit" type="POST" contentType="application/json"/>  
    <h:update url="${base.contextPath}/sys/resource/submit" type="POST" contentType="application/json"/>  
    <h:destroy url="${base.contextPath}/sys/resource/remove" type="POST" contentType="application/json"/> 
  </h:transport>
```

### **schema**

定义datasource的数据结构

#### **schema属性**

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| data | String \| Function | 包含数据项的服务器的相应字段 |
| errors | String \| Function | 包含服务器端的错误的数据 |
| groups | String \| Function | 包含组的服务器端数据 |
| parse | Function | 预处理解析服务器响应 |
| total | String \| Function | 数据项的总数 |
| type | String | 相应类型支持XML和JSON |

```xml
<h:dataSource id="gridDataSource" > 
  <h:schema data="rows" total="total" errors="schemaError">  
    ...
  </h:schema>
</h:dataSource>
```

#### **schema子节点**

* model

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| id | String | 唯一标识 |
| editable | Function | 设置是否可编辑 |

```xml
<h:schema data="rows" total="total" errors="schemaError"> 
    <h:model id="resourceId" editable="dsEditable"> 
      <h:fields> 
         ... 
      </h:fields> 
    </h:model> 
  </h:schema>
```

#### **model子节点**

* field

| 属性名 | 类型 | 描述 |
| :--- | :--- | :--- |
| name | String | 名字 |
| defaultValue | Object | 默认值 |
| editable | Boolean | 是否可编辑 |
| nullable | Boolean |  |
| parse | Function | 设为推送式 |
| type | String | 类型 |
| from | String |  |
| checkedValue | String |  为true设为选中 |
| uncheckedValue | String | 为true设为没选中 |

```xml
<h:schema data="rows" total="total" errors="schemaError"> 
    <h:model id="resourceId" editable="dsEditable"> 
      <h:fields> 
        <h:item name="loginRequire" defaultValue="Y" type="boolean" checkedValue="Y" uncheckedValue="N"/>  
        <h:item name="accessCheck" defaultValue="Y" type="boolean" checkedValue="Y" uncheckedValue="N"/>  
        <h:item name="type" defaultValue=""/>  
        <h:item name="url"> 
          <h:validation required="true"/> 
        </h:item>  
        <h:item name="name"> 
          <h:validation required="true"/> 
        </h:item> 
      </h:fields> 
    </h:model> 
  </h:schema>
```

#### **field子节点**

* validation

| 属性名 | 类型 |
| --- | --- |
| required | Boolean |
| max | Integer |
| min | Integer |

### **sort**

| 属性名 | 类型 |
| --- | --- |
| dir | String |
| field | String |
| compare | function |

```xml
    <h:dataSource id="gridDataSource" batch="true" pageSize="10" serverPaging="true" serverSorting="true" error="requestError">
      <h:transport parameterMap="parameterMap">
        ...
      </h:transport>
      <h:schema data="rows" total="total" errors="schemaError">
        <h:model id="resourceId" editable="dsEditable">
           <h:fields>
               ...
           </h:fields>
        </h:model>        
      </h:schema>
      <h:sort>
            <h:item field="url" dir="desc"/>
      </h:sort>
    </h:dataSource>
```



