## redis 安装与部署

## 一、安装
 
### 1.WINDOWS环境
Redis 支持 32 位和 64 位。这个需要根据你系统平台的实际情况选择，这里我们下载 Redis-x64-xxx.zip压缩包到 C 盘，解压后，将文件夹重新命名为 redis。

打开一个 cmd 窗口 使用cd命令切换目录到 C:\redis 运行 redis-server.exe redis.windows.conf (如果觉得麻烦可以将c:\redis加入到path中)。

### 2.LINUX环境
> $ wget http://download.redis.io/releases/redis-2.8.17.tar.gz  
> $ tar xzf redis-2.8.17.tar.gz  
> $ cd redis-2.8.17  
> $ make  

make完后 redis-2.8.17目录下会出现编译后的redis服务程序redis-server,还有用于测试的客户端程序redis-cli,两个程序位于安装目录 src 目录下：
下面启动redis服务.

>$ cd src  
$ ./redis-server redis.conf



上述安装完成后可以正常运行redis，但是redis推荐的做法是常用的文件和程序文件分离，这样做的好处是可以通过新建多个启动文件夹，以不同的参数启动多个redis服务，  
手动复制配置文件 redis.conf、sentinel.conf和执行脚本:redis-cli 、redis-server 、redis-sentinel到redis1目录下:  
![redis-dir](/assets/redis-dir.jpg)

 
新安装的redis需注意以下几点，按需求调整
 
1. 默认情况redis不是在后台运行,这种情况下关闭shell(命令窗口)就关闭了redis,我们需要把redis放在后台运行,设置了后台运行就得自己设置日志的输出位置  
 **设置redis.conf**   
 ```
 daemonize yes   
 loglevel notice#日志等级  
 logfile "/usr/redis/log/redis.log"#日志保存路径  
 ```
2. Redis默认只让本机连，对其它服务器不开放，需要配置bind参数。  
 ```
 bind  *
 ```
3. Redis默认开机不启动，需要将启动命令加入到/etc/rc.local中  
```
/opt/redis1/src/redis-server /opt/redis/redis1/redis.conf
```


 
 

##  二、部署
#### 1.搭建多个redis服务间的主从关系  
**Redis的主从（master-slave）就是为了数据冗余备份、保证数据的安全、提高性能。**
这里我们准备3个redis服务器，分别复制上面写到的redis1两份命名为redis2和redis3，修改每个redis的redis.conf文件 port和pidfile参数。
注意：pidfile也要改，Linux为每一个redis分配了一个pid进程号，如果这里不作修改，会影响后面redis服务的启动
 
服务名|端口|pidfile|身份  
| -- | -- | --| --|
redis1|6380|/var/run/redis_6380.pid|master|
redis2|6381|/var/run/redis_6381.pid|slave|
redis3|6382|/var/run/redis_6382 .pid|slave|

我们计划搭建成表中的关系，即redis1为主，redis2和redis3为从，给redis设置主从只需要在从服务的redis.conf加入  
 > slaveof 主服务器ip 主服务器端口

分别以下列方式启动3个redis服务:
```
./opt/redis1/redis-server /opt/redis1/redis.conf  
./opt/redis2/redis-server /opt/redis2/redis.conf  
./opt/redis3/redis-server /opt/redis3/redis.conf
```


3个redis服务都已经启动:  
![redis-server](/assets/redis01.png)


查看主redis服务的身份:
```
# redis-cli -h localhost -p 6380
# >info
```  
![redis](/assets/redis02.png) 


>- redis主从关系到此搭建完成，可是如果其中的主redis服务器宕机怎么办，岂不是整个服务都崩掉了？请看下节redis哨兵




## 2.redis哨兵

> Sentinel（哨兵）是Redis 的高可用性解决方案：由一个或多个Sentinel 实例组成的Sentinel系统可以监视任意多个主服务器，以及这些主服务器属下的所有从服务器，并在被监视的主服务器进入下线状态时，自动将下线主服务器属下的某个从服务器升级为新的主服务器。  


![redis](/assets/redis-sentinel.jpg)


> **提示:**

> - redis哨兵会监控主redis以及主redis下面的从redis，如果主redis下线后满足换老大（配置文件配置）的条件，哨兵会从从服务中选取某个redis成为主服务。


#### 配置redis哨兵
1. 配置端口   
在sentinel.conf 配置文件中， 我们可以找到port 属性，这里是用来设置sentinel 的端口，一般情况下，至少会需要三个哨兵对redis 进行监控，我们可以通过修改端口启动多个sentinel 服务。    
![redis](/assets/redis-sentinel01.png)
2. 配置主服务器的ip和端口   
我们把监听的端口修改成6380，并且加上权值为2，这里的权值，表示必须有两个哨兵监控到主redis下线才满足切换master的条件  
![redis](/assets/redis-sentinel02.png)

3. 启动Sentinel  
![redis](/assets/redis-sentinel03.png)  
sentinel 启动之后，就会监视到现在有一个主服务器，两个从服务器  

- **注意：** **我们这里只启动了一个哨兵，可是权值设置的是2**。


当我们把redis2从服务器关闭之后，我们可以看到日志   
![redis](/assets/redis-sentinel04.png)  
  
 
再启动redis2 (哨兵监听主服务器老大哥的同时，也关注了小弟的动态)   
![redis](/assets/redis-sentinel05.png)  



关闭主redis，发现并没有将提升slave成为master，原因是sentinel的权值设置为2，需要两个哨兵都认为主redis断线才切换。    
![redis](/assets/redis-sentinel06.png)  

**所以我们必须要启动两个哨兵对主redis进行监控，修改sentinel启动端口，监控对象不变，再启动一个哨兵**

关闭redis1（6380）后，哨兵告诉我们换了大哥了。  

查看redis3（6382），发现它已经成为大哥了    
![redis](/assets/redis-sentinel07.png)  

 
原先没有写的权限，现在也有了 。  
![redis](/assets/redis-sentinel08.png)  



当老大哥redis1（6380）回来后，怎么办，谁来当老大？  
![redis](/assets/redis-sentinel09.png) 
与实际相符，redis1只能当小弟了。。


#### **总结Sentinel的作用：**

* Master 状态监测
* 如果Master 异常，则会进行Master-slave 转换，将其中一个Slave作为Master，将之前的Master作为Slave 
* **Master-Slave切换后，master_redis.conf、slave_redis.conf和sentinel.conf的内容都会发生改变，即master_redis.conf中会多一行slaveof的配置，sentinel.conf的监控目标会随之调换**


#### **总结Sentinel的工作方式：**

1. 每个Sentinel以每秒钟一次的频率向它所知的Master，Slave以及其他 Sentinel 实例发送一个 PING 命令 
2. 如果一个实例（instance）距离最后一次有效回复 PING 命令的时间超过 down-after-milliseconds 选项所指定的值， 则这个实例会被 Sentinel 标记为主观下线。 
3. 如果一个Master被标记为主观下线，则正在监视这个Master的所有 Sentinel 要以每秒一次的频率确认Master的确进入了主观下线状态。 
4. 当有足够数量的 Sentinel（大于等于配置文件指定的值）在指定的时间范围内确认Master的确进入了主观下线状态， 则Master会被标记为客观下线 
5. 在一般情况下， 每个 Sentinel 会以每 10 秒一次的频率向它已知的所有Master，Slave发送 INFO 命令 
6. 当Master被 Sentinel 标记为客观下线时，Sentinel 向下线的 Master 的所有 Slave 发送 INFO 命令的频率会从 10 秒一次改为每秒一次 
7. 若没有足够数量的 Sentinel 同意 Master 已经下线， Master 的客观下线状态就会被移除。 若 Master 重新向 Sentinel 的 PING 命令返回有效回复， Master 的主观下线状态就会被移除。





 






