# Oracle,MySql,Sqlserver数据库配置


## 配置文件

1. 服务数据源配置
  * 融租易默认使用 JNDI 来配置数据源。数据源的配置独立于项目配置
  * 默认使用的 JNDI name 为 `jdbc/hel_dev`
  * tomcat 需要配置 context.xml：
    - Mysql 
    ```
    <Resource auth="Container" driverClassName="com.mysql.jdbc.Driver" url="jdbc:mysql://localhost:3306/hel" name="jdbc/hel_dev" type="javax.sql.DataSource" username="hel_dev" password="hel_dev"/>
    ```
    - Oracle
    ```
    <Resource auth="Container" driverClassName="oracle.jdbc.driver.OracleDriver" name="jdbc/hel_dev" type="javax.sql.DataSource" url="jdbc:oracle:thin:@127.0.0.1:1521:hel" username="hel_dev" password="hel_dev"/>
    ```
    - SqlServer
    ```
    <Resource auth="Container" driverClassName="com.microsoft.sqlserver.jdbc.SQLServerDriver" url="jdbc:sqlserver://127.0.0.1:1433; DatabaseName=hel" name="jdbc/hel_dev" type="javax.sql.DataSource" username="hel_dev" password="hel_dev"/>
    ```
   * 其他[应用服务器weblogic](/框架功能描述/deployment.md)等，需要按其配置方法 配置 JNDI

2. 数据库数据源配置
   > 融租易项目根目录的pom.xml中默认包含了 `Oracle`,`Mysql`,`SqlServer` 的 JDBC 驱动，一般不需要改动
   
  * 修改  resources/config.properties
     *  当数据库为 oracle 时
     ```
     db.type=oracle
     db.jndiName=java:comp/env/jdbc/hel_dev
     mybatis.identity=SEQUENCE
     ```
     
     * 当数据库为mysql时
         ```
         db.type=mysql
         db.jndiName=java:comp/env/jdbc/hel_dev
         ```
     * 修改完毕后复制一份放到 resources/profiles/dev (覆盖)

3. redis服务配置
修改resources/config.properties：
  * 配置单个redis的时候只需配置
```
redis.ip=172.20.0.115
  redis.port=6379
  redis.db=1
```
  * 当配置redis集群时需配置
```
redis.useSentinel=true  --为true时单个redis配置熟悉失效
redis.sentinel=\
  10.86.20.183:26379,\
  10.86.20.184:26379
```

  




