# 消息机制

简介：实时弹出提示消息或待办

### 1.消息机制入口

对任何需要提示的操作，都需要将这个消息以键-值对的形式存入到redis中，调用setNoticeCache（）方法即可

```java
SysEventServieImpl.java   


    @Override
    public void setNoticeCache(HlsSystemNotice hlsSystemNotice) {
        sysNoticePushService.sendUserNotice(hlsSystemNotice.getSource_user_id(),hlsSystemNotice);
        List<HlsSystemNotice> noticeToList= hlsSystemNoticeService.selectSendNotice(hlsSystemNotice);
        if(noticeToList!=null){
            for(HlsSystemNotice hlsSystemNotice1:noticeToList){
                sysNoticePushService.sendUserNotice(hlsSystemNotice1.getUserId(),hlsSystemNotice);
            }
        }
    }
```

redis中的存在形式：

```java
   SysNoticePushServiceImpl.java
   
     @Override
    public void sendUserNotice(Long userId, HlsSystemNotice hlsSystemNotice) {
        String hashKey = "messageBox-" + userId.toString() + "-" + System.currentTimeMillis() + "-" + Math.random();
        String key = "messageBox-" + userId.toString();
        hashOperations.put(hashKey, "userId", hlsSystemNotice);
        listOperations.rightPush(key, hashKey);
    }
```

前端以ajax轮询的方法发送请求获取需要展示的消息：

```js
<script>
   setInterval(moment_show,6000);
   function moment_show(contextPath){
        $.ajax({
            type: 'POST',
            async: false, //设为同步
            url: '${base.contextPath}/hls/user/send/notice',
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            success: function (datas) {
                if(datas.length>0) {
                    push_float_msg(datas);
                    setTimeout(function(){moment_hide(msgLength);},3000);
                }
            }
        });
    };
</script>
```

redis中取值机制：

```java
  SysNoticePushServiceImpl.java 
    
      @Override
    public List<HlsSystemNotice> getUserNotice(Long userId) {
        String key = "messageBox-" + userId.toString();
        List<HlsSystemNotice> retList = new ArrayList<HlsSystemNotice>();
        if(listOperations!=null){
            List<String> keys = listOperations.range(key, 0, -1);
            for (int i = 0; i < keys.size(); i++) {
                if (i == 5) {
                    break;
                }
                boolean rep = true;
                boolean currentUserTodo = false;
                if(hashOperations!=null){
                    HlsSystemNotice hlsSystemNotice = (HlsSystemNotice) hashOperations.get(keys.get(i), "userId");
                    for (int m = 0; m < retList.size(); m++) {
                        if (retList.get(m).getNotice_id() == hlsSystemNotice.getNotice_id()) {
                            rep = false;
                        }
                    }
                    if (hlsSystemNotice.getNotice_type() == "TO_DO") {
                        if (hlsSystemNotice.getSource_user_id() == userId) {
                            currentUserTodo = true;
                        } else {
                            currentUserTodo = false;
                        }
                    } else {
                        currentUserTodo = true;
                    }
                    if (rep && currentUserTodo) {
                        retList.add(hlsSystemNotice);
                    }
                    listOperations.remove(key,1,keys.get(i));
                    hashOperations.delete(keys.get(i),"userId");
                }
            }
        }else {
            HlsSystemNotice notice = new HlsSystemNotice();
            notice.setNotice_title("test");
            notice.setUserId(Long.parseLong("10172"));
            notice.setRead_flag("N");
            notice.setDone_flag("N");
            notice.setNotice_message("test-msg");
            retList.add(notice);
        }
        return retList;
    }
}
```



