# 新建数据库

# 1. 创建数据库-Mysql

> 在开始之前最好修改一下 MySQL的配置文件 my.cnf (or my.ini)
,在 [mysqld] 下添加

```
lower_case_table_names=1
character_set_server=utf8
max_connections=500
```

   * 用管理员登陆mysql
   * 创建数据库hel_dev
 
   ```sql
   create schema hel_dev default character set utf8;
   ```
   
   * 创建用户hel_dev,并将密码设置为hel_dev
   
   ```sql
   CREATE USER hel_dev@'%' IDENTIFIED BY 'hel_dev';
   CREATE USER hel_dev@'localhost' IDENTIFIED BY 'hel_dev';
   ```
   * 将上面新建的hel_dev权限赋予用户hel  
   
   ```sql
   GRANT ALL PRIVILEGES ON hel_dev.* TO hel_dev@'%';
   GRANT ALL PRIVILEGES ON hel_dev.* TO hel_dev@'localhost';
   flush privileges; 
   ```
# 2. 创建数据库-Oracle
  * 使用管理员登陆
  * 创建表空间  
 
  ```sql
  CREATE BIGFILE TABLESPACE tbs_perm_hel
    DATAFILE 'tbs_perm_hel.dat'
      SIZE 200M
      AUTOEXTEND ON NEXT 20M MAXSIZE 500M;  
  ```    
  ```sql
  CREATE TEMPORARY TABLESPACE tbs_temp_hel
    TEMPFILE 'tbs_temp_hel.dbf'
    SIZE 200M
    AUTOEXTEND ON NEXT 20M MAXSIZE 500M;
  ```
   
  * 创建用户 schema   
     
  ```sql
  CREATE USER hel_dev
    IDENTIFIED BY hel_dev
    DEFAULT TABLESPACE tbs_perm_hel
    TEMPORARY TABLESPACE tbs_temp_hel
    QUOTA 200M on tbs_perm_hel;
  ```
    
  * 授权
          
  ```sql  
  GRANT create session TO hel_dev;
  GRANT create table TO hel_dev;
  GRANT create view TO hel_dev;
  GRANT create any trigger TO hel_dev;
  GRANT create any procedure TO hel_dev;
  GRANT create sequence TO hel_dev;
  GRANT create synonym TO hel_dev;
  ```

# 3. 创建数据库-sql server
  * 使用管理员登陆
  * 创建数据库 
 
  ```sql
  CREATE DATABASE hel_dev COLLATE Chinese_PRC_CI_AS;
  ```    
   
  * 创建用户 hel 并授权  
     
  ```sql
  sp_addlogin 'hel','hel_dev';
  use hel_dev
  go
  sp_adduser 'hel_dev','hel_dev'
  go
  sp_addrolemember 'db_owner','hel'
  go
  ```