## Excel文件导入
使用poi解析xml方式进行导入，只支持单表导入。  
数据库批量导入默认batch为100.  
支持多sheet导入，sheet1从第三行开始读取数据，其他sheet页从第一行导入数据。  
使用方法： 
1. Excel文件上传  

    ```javascript
     $("#files").kendoUpload({
                async: {
                    saveUrl: "${base.contextPath}/hls/excel/import?${_csrf.parameterName}=${_csrf.token}&templateCode=HLS_FIN_STATEMENT_LN",
                    removeUrl: "remove"
                },
                showFileList: false,
                upload: onUpload,
                success: onSuccess
            });
    ```
| 参数名 | 描述 |
| :--: | :--: |
| _csrf.token | 防跨域token |
|  templateCode | 作为模块标识，会出现先在fnd_interface_header中，供后续业务逻辑进行处理  |
2. 处理数据  
经过第一步的文件上传，后台会在fnd_interface_header表中生成一条数据，其中包含了传递的templateCode参数作为code，并且，在fnd_interface_lines表中按照顺序，将Excel文件中的每一行数据保存为一条数据，数据的第一列保存在attributes_1上，依次类推。 
![ExcelImport](/assets/excelImport.png) 

## Excel文件批量导出
本系统支持Excel文件导出排队处理，支持超大数据量，能实时查询文件生成情况，支持取消导出。
#### 前端使用方法
调用js方法  

```javascript
 Hel.exportExcel=function(opts){
     var contextPath =opts.contextPath, 
     id=opts.id, 
     view_model=opts.viewModel,
     viewModelData=opts.viewModelData,
     controller_name = opts.controller, 
     fileName = opts.fileName, 
     temp_div_id=opts.tempDivId,
     dataSourceId = opts.dataSourceId,
     _csrf_token = opts._csrf_token;
```
| 参数名 | 描述 |
| :--: | :--: |
| contextPath | 项目的url路径 |
| id |  页面上grid的id  |
| view_model | grid绑定的model数据模型  |
| viewModelData | model模型中的数据 | 
| controller_name | 后端控制器名称 |
| fileName | excel文件名 |
| temp_div_id | 临时div的id |
| dataSourceId | 数据源id |
| _csrf_token | 防跨域的token |

#### 后端使用方法
1. 在代码中注入Excel导出Service  

    ```java
    @AutoWired
    private ExcelExportServiceImpl excelService;
    ```
2. 在自己的controller中调用方法 
    
    ```java
    excelService.saveExportInfo(sqlId,iRequest,config,rowMaxNumber);
    ```
    
    | 参数名 | 类型 | 描述 |
    | :--: | :--: | :--: |
    | sqlId | String | mybatis对应的数据库查询语句的ID |
    | iRequest | IRequest | 带有上下文信息的reuqest对象  |
    | config | ExportConfig | 包含Excel各列信息的对象，由前台传递json对象转换而来  |
    | rowMaxNumber | int | 生成Excel的最大行数，可使用重载方法，不包含次参数默认为1,000,000  |

3. 运行Excel导出程序(获取该程序，请联系部门相关负责人)  

    ```shell
    java -jar hel-batch-parent.jar &
    ```
4. Excel导出情况查询   
用户若是为管理员身份，则查询全部人的导出情况，否则只显示当前用户的导出数据  

    ```java
    excelService.queryExportInfo(status, iRequest);
    ```
    
    | 参数名 | 类型 | 描述 |
    | :--: | :--: | :--: |
    | status | String | 指定Excel导出的状态，该参数可为空查询全部状态数据<br><ul><li>new->等待</li><li>generating->文件导出中</li><li>finished->导出完成</li><li>failed-> 导出失败</li></ul> |
    | iRequest | IRequest | 带有上下文信息的reuqest对象  |

5. 下载已完成的Excel文件  

    ```java
    excel.downloadExcel(filePath, fileName, request, response);
    ```
    
    | 参数名 | 类型 | 描述 |
    | :--: | :--: | :--: |
    | filePath | String | 需要下载的文件的路径 |
    | fileName | String | 想要保存的文件的名称  |
    | request | HttpServletRequest | 用户的请求对象  |
    | response | HttpServletResponse | 用户的响应对象 |

**下载前，需要检查config.properties文件中的export.offerUrl配置项是否配置正确，且为hel-batch-parent.jar提供的文件下载url**