# HlsHbox（分行标签）

说明：将标签的内的内容放在同一模块里面（一般放在同一行宽度不够时会转行），继承&lt;div&gt;标签的一般属性

```html
<h:hlsHBox>
    <h:hlsMaskedTextBox name="userId" id="maskedtextbox" bind="enabled: isEnabled, value:data.userId" colspan="2" prompt="TextBox:" promptColspan="1" required="true" validationMessage="Enter {0}"/>
    <h:hlsCombobox name="combobox" id="combobox" bind="enabled: isEnabled, source: comboboxSource, value:data.productId" colspan="2" dataTextField="text" dataValueField="value" placeholder="combobox" prompt="Combobox:" promptColspan="1" valuePrimitive="true"/>
    <h:hlsLov name="lov" id="lov" code="LOV_ROLE" colspan="2" contextPath="${base.contextPath}" data-bind="enabled: isEnabled, value:data.userId,text:data.userName" locale="${base.locale}" placeholder="lov" prompt="Lov:" promptColspan="1" query="lovQuery" select="lovSelect" style="width: 100%"/>
    <h:hlsDatePicker name="datepicker" id="datepicker" bind="enabled: isEnabled,value:data.birthday" colspan="2" placeholder="datepicker" prompt="datepicker:" promptColspan="1" required="true"/>
</h:hlsHBox>
<h:hlsHBox>
    <h:hlsTlEdit id="tl" bind="value:data.name" dto="com.hand.hap.function.dto.Resource" field="name" idField="id" model="viewModel.data" placeholder="多语言" prompt="TlEdit:"/>
    <h:hlsCheckbox name="checkbox" bind="enabled: isEnabled,value:data.checkbox" bindModel="viewModel" checked="checked" checkedValue="Y" prompt="Checkbox:" uncheckedValue="N"/>
    <h:hlsCombobox id="products" cascadeFrom="combobox" dataSource="productsData" dataTextField="code" dataValueField="code" disabled="true" filter="contains" placeholder="Select product..." prompt="Combobox:"/>
    <h:hlsDropDownList name="dropdownlist" id="dropdownlist" bind="enabled: isEnabled, source: comboboxSource, value:data.productId" colspan="2" dataTextField="text" dataValueField="value" placeholder="dropdownlist" prompt="DropDownList:" promptColspan="1" valuePrimitive="true"/>
</h:hlsHBox>
<h:hlsHBox>
    <h:hlsTextArea id="tla" bind="value:data.name" colspan="4" style="width:500px" dto="com.hand.hap.function.dto.Resource" field="name" idField="id" model="viewModel.data" placeholder="多语言" prompt="TlEdit:"/>
</h:hlsHBox>
```

效果图![](/assets/802170358.png)

