# 工作流开发指南

一、工作流开发整体思路
* 流程设计
* 实现启动接口
* 调用实现类
* 启动工作流   

二、流程设计

1 新建工作流并填写对应的信息
![](/assets/wfl_demo_1.png)
![](/assets/wfl_demo_2.png)

*这里需要注意分类跟唯一标识这个字段，后面编写实现类的时候需要传入分类跟唯一标识。

2 保存之后点击对应工作流的第一个图标，即可编辑对应的工作流节点，下面将详细介绍一些常用的工作流属性（新建工作流的时候可参考已实现工作流）

* ID:自动生成，节点唯一标识
* 名称:当前节点中文描述
* 文档：消息机制，可在上下文中取到，如：我是${name},name为实现类里面配置的参数
* 审批方式：默认为全部通过
* 审批方式变量：当审批方式选择一定比例时，可设置变量如0.4，表示当审批人数达到这个比例后将会通过     

* 审批规则：选择对应的审批人，可在审批规则中定义
* 加签：若勾选，则当前审批者可添加审批人
* 表单url：表示审批流程中可插入的页面，能让审判者读阅
* 执行监听器：执行监听器start跟end两种分别代表在该节点之前跟在该节点之后，在代理表达式里面可调用对应自己写的java类，格式如下：${endActionEventTask}
* 任务监听器：任务监听器可参考执行监听器

下图是一个完整的工作流流程设计
![](/assets/wfl_demo_3.png)

二、实现启动接口

* 编写一个自己的实现类，实现IActivitiCommonService接口  


![](/assets/wfl_demo_4.png)  


实现类代码如下
```java

@Service
@Transactional
public class PrjActivitStartServiceImpl implements IActivitiCommonService
 { 
    private static final String workFlowType = "PRJ_PROJECT"; 
    @Autowired     
    private IActivitiService activitiService;
    @Autowired 
    private IReProcdefService reProcdefService;
    @Autowired 
    private PrjProjectService projectService;
    @Autowired 
    private PrjProjectMeetingMapper meetingMapper; 
    @Override 
    public String getWorkFlowType() { return workFlowType; } 
    @Override 
    public void process(IRequest iRequest, List list, Map params) 
    {
         ProcessInstanceCreateRequest processInstanceCreateRequest = getProcessInstanceCreateRequest((PrjProject)list.get(0),iRequest);
         activitiService.startProcess(iRequest, processInstanceCreateRequest);
    }
     private ProcessInstanceCreateRequest getProcessInstanceCreateRequest(PrjProject prjProject, IRequest iRequest) 
    { 
        ProcessInstanceCreateRequest createRequest = new ProcessInstanceCreateRequest();
        PrjProject project=projectService.selectByPrimaryKey(iRequest,prjProject); ReProcdef reProcdefs ;  
        reProcdefs = reProcdefService.queryReProcdef("PRJ_PROJECT_APPROVE","PRJ_PROJECT");  
        String id = reProcdefs.getId_();
        String name = reProcdefs.getName_(); createRequest.setProcessDefinitionId(id);                       
        createRequest.setBusinessKey(prjProject.getProjectId().toString()); 
        List<RestVariable> variables = new ArrayList<RestVariable>(); List<RestVariable> transientVariables = new ArrayList<RestVariable>();
        RestVariable restVariable1 = new RestVariable(); RestVariable restVariable2 = new RestVariable(); 
        RestVariable restVariable3 = new RestVariable(); 
        RestVariable restVariable4 = new RestVariable();
        RestVariable restVariable5 = new RestVariable(); 
        RestVariable restVariable6 = new RestVariable(); 

        restVariable1.setName("processDefinitionId"); 
        restVariable1.setValue(id); variables.add(restVariable1); 
        restVariable2.setName("prjProject"); 
        JSONObject jsonObject= new JSONObject().fromObject(prjProject); restVariable2.setValue(jsonObject.toString());                                          
        variables.add(restVariable2); 
        restVariable3.setName("iRequest"); restVariable3.setValue(iRequest); 
        variables.add(restVariable3); 
        restVariable4.setName("projectNum"); restVariable4.setValue(project.getProjectNumber()); variables.add(restVariable4);         
        restVariable5.setName("projectName"); restVariable5.setValue(project.getProjectName()); variables.add(restVariable5);     
        restVariable6.setName("startUserName"); restVariable6.setValue(iRequest.getEmployeeCode()); variables.add(restVariable6);
        RestVariable restVariable7 = new RestVariable(); 
        RestVariable restVariable8 = new RestVariable(); RestVariable restVariable9 = new RestVariable();         
        restVariable7.setName("documentCategory"); restVariable7.setValue(project.getDocumentCategory()); variables.add(restVariable7);         
        restVariable8.setName("documentType"); restVariable8.setValue(project.getDocumentType()); 
        variables.add(restVariable8); restVariable9.setName("documentId"); restVariable9.setValue(project.getProjectId()); 
        variables.add(restVariable9);
        RestVariable restVariable10 = new RestVariable(); 
        restVariable10.setName("doubleFlag");
        PrjProjectMeeting meeting = new PrjProjectMeeting(); 
        meeting.setProjectId(prjProject.getProjectId()); 
        List<PrjProjectMeeting> list = meetingMapper.select(meeting); if(list.size() >0) { restVariable10.setValue("Y"); }else{         
        restVariable10.setValue("N"); }
        variables.add(restVariable10);
        RestVariable restVariable11 = new RestVariable(); restVariable11.setName("pName"); 
        restVariable11.setValue(name);
        variables.add(restVariable11); createRequest.setVariables(variables); createRequest.setTransientVariables(transientVariables);
        return createRequest; 
}}

```

* 关键参数讲解：
private static final String workFlowType = "PRJ_PROJECT";在启动工作流的时候工作流会根据这个类型找到对应的实现类，
在启动工作流的时候会调用process方法，该方法会调用getProcessInstanceCreateRequest方法，在getProcessInstanceCreateRequest方法里面
可以将自己工作流所需参数都放到里面去，可以在后面的流程中取到自己所需参数。
reProcdefs = reProcdefService.queryReProcdef("PRJ_PROJECT_APPROVE","PRJ_PROJECT");参数一为创建工作流时候的唯一标志，参数二为工作流的分类


三 调用实现类并启动工作流
 ```
Map<String,Object> params = new HashMap<String,Object>();
params.put("workFlowType","PRJ_PROJECT");
activitiStartService.start(iRequest,projects,params);

```

* 代码解析

params.put("workFlowType","PRJ_PROJECT");放入的为工作流实现类的类型
