# hlsLOV标签



#### lov标签的数据源和展示由功能定义，因此在写LOV之前需要在lov配置功能处配好相关信息,可配置项包括：
##### 1.lov框的具体样式、结构; 
##### 2.lov框的数据来源





```xml
//code、locale、contenxtPath为必须的参数，其中code为所需lov在lov定义时的code的值

 <h:hlsLov name="lov" id="lov" code="LOV_CON_CONTRACT_TENANT" contextPath="${base.contextPath}" locale="${base.locale}"/>
```


#### **必须参数**
参数名|类型/值
----|----
code|String
locale|String (一般为${base.locale})
contextPath|String（一般为${base.contextPath}）

#### **一般属性**

属性名|类型
----|----
promptColspan | String 
promptClassName | String 
promptImage | String 
prompt | String 
name|String
enabled|Boolean
valuePrimitive|Boolean
text|String
dataTextField|String
dataValueField|String
open|function
close|function
select|function
query|function





用法示例：

```javascript

var viewModel = kendo.observable({
	enabled: true,
	isEnabled: false,
	data: {},
});

//以下代码写在script标签内
//lov查询时触发
function lovQuery(e) {
        //lov查询拼上条件
        e.param['contractId'] = 1237;  
      };
      
      
//选中lov行数据后触发  
function lovSelect(e) {
      //选中lov行数据后
      //options是
      viewModel.data.set("contractId", e.item.contractId);
      };
      
```

```xml

<!--xml代码-->
<h:hlsLov name="lov" id="lov" code="LOV_ROLE" colspan="3" contextPath="${base.contextPath}" data-bind="enabled: enabled, locale="${base.locale}" placeholder="承租人名称" prompt="lov:" promptColspan="1" select="lovSelect" query="lovQuery" style="width: 100%"/>

```


> **提示:**

> - 上述所有属性直接添加在标签内即可，（**[属性名] = "..."**）,对于既是**String**类型又是**Function**类型的属性，只需要加**fn:**前缀区分即可,（**fn:函数名**）








