# 融租易开发手册

* [GitBook使用](/gitbook.md)

---

* I. 开发环境准备

  * [1.1 Git 使用](/git-guide.md "git指令")
  * [1.2 Maven 使用](/maven.md "maven使用")
  * [1.3 开发环境搭建](/project-create.md)
  * [1.4 更新项目的HEL依赖版本](/project-update.md)
  * [1.5 Liquibase](/liquibase-use.md)

* II. 项目开发规范

  * [2.1 项目开发规范](/codeStyle.md#backEndDev)
  * [2.2 编码规范](/codeStyle.md#backEndName)
  * 2.3 Checkstyle

* III. 后端开发

  * [3.1 后端开发说明\(1.0\)](/后端开发/dev-flow.md)
  * [3.2 用户安全策略](/后端开发/user-security-strategy.md)
  * [3.3 审计](/后端开发/audit.md)
  * [3.4 锁机制](/后端开发/lock.md)
  * [3.5 日志管理](/后端开发/elk.md)
  * [3.6 代码生成器](/后端开发/code-generator.md)
  * [3.7 跨域访问](/后端开发/3.24-cors.md)

* IV. 前端JavaScript开发

  * [4.1 前端开发说明 \(1.0\)](/front-kendoui.md)
  * [4.2 字段级通用方法](/common-field-javascript.md)
  * [4.3 窗口级通用方法](/common-window-javascript.md)
  * [4.4 锁屏和解屏通用方法](/common-mask-javascript.md)

* V. 前端UI开发

  * [5.1  hlsCombobox\(下拉框\)](/前端组件/hlsCombobox.md)
  * 5.2  [hlsDataSource\(数据源\)](/前端组件/hlsDataSource.md)
  * [5.3  hlsMaskedTextBox](/前端组件/hlsMaskedTextBox.md)
  * [5.4  hlsPage](/前端组件/hlsPage.md)
  * [5.5  hlsTextArea](/前端组件/hlsTextArea.md)
  * [5.6  hlsTlEdit](/前端组件/hlsTlEdit.md)
  * [5.7  hlsDatePicker\(日期选择框\)](/前端组件/hlsDatePicker.md)
  * [5.8  hlsDateTimePicker\(时间选择框\)](/前端组件/hlsDateTimePicker.md)
  * [5.9  hlsLov\(lov选择框\)](/前端组件/hlsLov.md)
  * [5.10 hlsToolBar\(底部菜单栏\)](/前端组件/hlsToolBar.md)
  * [5.11 TabStrip\(sheet页切换卡\)](/前端组件/tabStrip.md)
  * [5.12 hlsForm\(表单\)](/前端组件/hlsForm.md)
  * [5.13 hlsCombobox](/前端组件/hlsCombobox.md)
  * [5.14 hlsCheckBox\(复选框\)](/前端组件/hlsCheckBox.md)
  * [5.15 grid\(表格\)](/前端组件/grid.md)
  * [5.16 dataSource\(数据源\)](/前端组件/dataSource.md)
  * [5.17 hlsGridBox\(表格\)](/前端组件/hlsGridBox.md)
  * [5.18 hlsNumericTextBox\(数字框\)](/前端组件/hlsNumericTextBox.md)
  * [5.19 hlsNavigationBar\(导航栏\)](/前端组件/hlsNavigationBar.md)

* VI. 框架功能描述

  * [6.1 计划任务](/框架功能描述/计划任务.md)
  * [6.2 RabbitMq消息队列](/后端开发/RabbitMq消息队列.md)
  * [6.3 应用服务部署\(tomcat/weblogic\)](/框架功能描述/deployment.md)
  * [6.4 合同文本生成](/框架功能描述/docx4j.md)
  * [6.5 Excel导入导出](/框架功能描述/jad.md)
  * [6.6 redis安装和部署](/后端开发/redis.md)



