create table sys_dp_execute_history
(
    deh_id  number not null,
    deh_user_id number,
    deh_ip varchar2(200),
    deh_execute_time date,
    deh_execute_type varchar2(10),
    deh_row_count number,
    deh_context clob,
    deh_status varchar2(10),
    deh_error varchar2(2000),
    deh_bak_data clob,
    OBJECT_VERSION_NUMBER number DEFAULT 1,
    REQUEST_ID number DEFAULT -1,
    PROGRAM_ID number DEFAULT -1,
    CREATED_BY number DEFAULT -1,
    CREATION_DATE date DEFAULT sysdate,
    LAST_UPDATED_BY number DEFAULT -1,
    LAST_UPDATE_DATE date DEFAULT sysdate,
    LAST_UPDATE_LOGIN number DEFAULT -1
);
comment on table SYS_DP_EXECUTE_HISTORY
  is '数据处理执行记录';
comment on column sys_dp_execute_history.deh_id
    is 'PK';
comment on column sys_dp_execute_history.deh_user_id
    is '执行人用户ID';
comment on column sys_dp_execute_history.deh_ip
    is '执行IP';
comment on column sys_dp_execute_history.deh_execute_time
    is '执行时间';
comment on column sys_dp_execute_history.deh_execute_type
    is '执行类型 insert update delete query';
comment on column sys_dp_execute_history.deh_row_count
    is '执行结果条数';
comment on column sys_dp_execute_history.deh_context
    is '执行内容';
comment on column sys_dp_execute_history.deh_status
    is '执行状态';
comment on column sys_dp_execute_history.deh_error
    is '错误信息';
comment on column sys_dp_execute_history.deh_bak_data
    is '备份源数据';

create index sys_dp_execute_history_n1 on sys_dp_execute_history(deh_user_id);
create index sys_dp_execute_history_n2 on sys_dp_execute_history(deh_ip);

alter table sys_dp_execute_history add constraint sys_dp_execute_history_pk primary key (deh_id);