CREATE TABLE  "SYS_TOKEN_LOGS" (
  "ID" NUMBER(38) NOT NULL ,
  "USER_ID" NUMBER(38) ,
  "CLIENT_ID" VARCHAR2(100 BYTE) NOT NULL ,
  "TOKEN" VARCHAR2(1024 BYTE) ,
  "TOKEN_ACCESS_TIME" TIMESTAMP(6) ,
  "TOKEN_ACCESS_TYPE" VARCHAR2(32 BYTE) ,
  "TOKEN_EXPIRES_TIME" TIMESTAMP(6) ,
  "REVOKE_FLAG" VARCHAR2(5 BYTE) DEFAULT 'Y' ,
  "OBJECT_VERSION_NUMBER" NUMBER(38) DEFAULT 1 ,
  "REQUEST_ID" NUMBER(38) DEFAULT -1 ,
  "PROGRAM_ID" NUMBER(38) DEFAULT -1 ,
  "CREATED_BY" NUMBER(38) DEFAULT -1 ,
  "CREATION_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATED_BY" NUMBER(38) DEFAULT -1 ,
  "LAST_UPDATE_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATE_LOGIN" NUMBER(38) DEFAULT -1 
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."ID" IS '日志ID';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."USER_ID" IS '用户ID';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."CLIENT_ID" IS '客户端ID';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."TOKEN" IS 'token';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."TOKEN_ACCESS_TIME" IS 'token获取日期';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."TOKEN_ACCESS_TYPE" IS 'token获取方式';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."TOKEN_EXPIRES_TIME" IS 'token失效日期';
COMMENT ON COLUMN  "SYS_TOKEN_LOGS"."REVOKE_FLAG" IS '是否有效';

-- ----------------------------
-- Primary Key structure for table SYS_TOKEN_LOGS
-- ----------------------------
ALTER TABLE  "SYS_TOKEN_LOGS" ADD CONSTRAINT "PK_SYS_TOKEN_LOGS" PRIMARY KEY ("ID");

-- ----------------------------
-- SEQUENCE for table SYS_TOKEN_LOGS
-- ----------------------------
CREATE SEQUENCE  "SYS_TOKEN_LOGS_S"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 10041 CACHE 20 NOORDER  NOCYCLE

-- ----------------------------
-- Indexes structure for table SYS_TOKEN_LOGS
-- ----------------------------
CREATE INDEX  "SYS_TOKEN_LOGS_N1"
  ON  "SYS_TOKEN_LOGS" ("USER_ID" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_TOKEN_LOGS_N2"
  ON  "SYS_TOKEN_LOGS" ("CLIENT_ID" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
