CREATE TABLE  "SYS_IF_INVOKE_OUTBOUND" (
  "OUTBOUND_ID" NUMBER(38) NOT NULL ,
  "INTERFACE_NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "INTERFACE_URL" VARCHAR2(200 BYTE) NOT NULL ,
  "REQUEST_TIME" TIMESTAMP(6) NOT NULL ,
  "REQUEST_PARAMETER" CLOB ,
  "REQUEST_STATUS" VARCHAR2(10 BYTE) ,
  "RESPONSE_CONTENT" CLOB ,
  "RESPONSE_TIME" NUMBER(38) ,
  "RESPONSE_CODE" VARCHAR2(30 BYTE) ,
  "STACKTRACE" CLOB ,
  "OBJECT_VERSION_NUMBER" NUMBER(38) DEFAULT 1 ,
  "REQUEST_ID" NUMBER(38) DEFAULT -1 ,
  "PROGRAM_ID" NUMBER(38) DEFAULT -1 ,
  "CREATED_BY" NUMBER(38) DEFAULT -1 ,
  "CREATION_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATED_BY" NUMBER(38) DEFAULT -1 ,
  "LAST_UPDATE_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATE_LOGIN" NUMBER(38) DEFAULT -1 
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."OUTBOUND_ID" IS 'pk';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."INTERFACE_NAME" IS '接口名称';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."INTERFACE_URL" IS '接口地址';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."REQUEST_TIME" IS '请求时间';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."REQUEST_PARAMETER" IS '请求参数';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."REQUEST_STATUS" IS '请求状态';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."RESPONSE_CONTENT" IS '响应内容';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."RESPONSE_TIME" IS '响应时间';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."RESPONSE_CODE" IS 'httpCode';
COMMENT ON COLUMN  "SYS_IF_INVOKE_OUTBOUND"."STACKTRACE" IS '错误堆栈';

-- ----------------------------
-- Primary Key structure for table SYS_IF_INVOKE_OUTBOUND
-- ----------------------------
ALTER TABLE  "SYS_IF_INVOKE_OUTBOUND" ADD CONSTRAINT "SYS_IF_INVOKE_OUTBOUND_PK" PRIMARY KEY ("OUTBOUND_ID");

-- ----------------------------
-- Checks SEQUENCE
-- ----------------------------

CREATE SEQUENCE  "SYS_IF_INVOKE_OUTBOUND_S"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 10021 CACHE 20 NOORDER  NOCYCLE

-- ----------------------------
-- Indexes structure for table SYS_IF_INVOKE_OUTBOUND
-- ----------------------------
CREATE INDEX  "SYS_IF_INVOKE_OUTBOUND_N1"
  ON  "SYS_IF_INVOKE_OUTBOUND" ("INTERFACE_NAME" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_OUTBOUND_N2"
  ON  "SYS_IF_INVOKE_OUTBOUND" ("INTERFACE_URL" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_OUTBOUND_N3"
  ON  "SYS_IF_INVOKE_OUTBOUND" ("REQUEST_TIME" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_OUTBOUND_N4"
  ON  "SYS_IF_INVOKE_OUTBOUND" ("REQUEST_STATUS" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
