CREATE TABLE  "SYS_IF_INVOKE_INBOUND" (
  "INBOUND_ID" NUMBER(38) NOT NULL ,
  "INTERFACE_NAME" VARCHAR2(255 BYTE) NOT NULL ,
  "INTERFACE_URL" VARCHAR2(200 BYTE) NOT NULL ,
  "REQUEST_TIME" TIMESTAMP(6) NOT NULL ,
  "REQUEST_HEADER_PARAMETER" VARCHAR2(2000 BYTE) ,
  "REQUEST_BODY_PARAMETER" CLOB ,
  "REQUEST_METHOD" VARCHAR2(10 BYTE) ,
  "REQUEST_STATUS" VARCHAR2(10 BYTE) ,
  "RESPONSE_CONTENT" CLOB ,
  "RESPONSE_TIME" NUMBER(38) ,
  "STACKTRACE" CLOB ,
  "IP" VARCHAR2(40 BYTE) ,
  "REFERER" VARCHAR2(240 BYTE) ,
  "USER_AGENT" VARCHAR2(240 BYTE) ,
  "OBJECT_VERSION_NUMBER" NUMBER(38) DEFAULT 1 ,
  "REQUEST_ID" NUMBER(38) DEFAULT -1 ,
  "PROGRAM_ID" NUMBER(38) DEFAULT -1 ,
  "CREATED_BY" NUMBER(38) DEFAULT -1 ,
  "CREATION_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATED_BY" NUMBER(38) DEFAULT -1 ,
  "LAST_UPDATE_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATE_LOGIN" NUMBER(38) DEFAULT -1 
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."INBOUND_ID" IS 'pk';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."INTERFACE_NAME" IS '接口名称';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."INTERFACE_URL" IS '接口地址';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."REQUEST_TIME" IS '请求时间';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."REQUEST_HEADER_PARAMETER" IS '请求header参数';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."REQUEST_BODY_PARAMETER" IS '请求body参数';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."REQUEST_METHOD" IS '请求方式';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."REQUEST_STATUS" IS '请求状态';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."RESPONSE_CONTENT" IS '响应内容';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."RESPONSE_TIME" IS '响应时间';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."STACKTRACE" IS '错误堆栈';
COMMENT ON COLUMN  "SYS_IF_INVOKE_INBOUND"."IP" IS 'ip地址';

-- ----------------------------
-- Primary Key structure for table SYS_IF_INVOKE_INBOUND
-- ----------------------------
ALTER TABLE  "SYS_IF_INVOKE_INBOUND" ADD CONSTRAINT "SYS_IF_INVOKE_INBOUND_PK" PRIMARY KEY ("INBOUND_ID");


-- ----------------------------
-- Indexes structure for table SYS_IF_INVOKE_INBOUND
-- ----------------------------
CREATE INDEX  "SYS_IF_INVOKE_INBOUND_N1"
  ON  "SYS_IF_INVOKE_INBOUND" ("INTERFACE_NAME" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_INBOUND_N2"
  ON  "SYS_IF_INVOKE_INBOUND" ("INTERFACE_URL" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_INBOUND_N3"
  ON  "SYS_IF_INVOKE_INBOUND" ("REQUEST_TIME" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
CREATE INDEX  "SYS_IF_INVOKE_INBOUND_N4"
  ON  "SYS_IF_INVOKE_INBOUND" ("REQUEST_STATUS" ASC)
  LOGGING
  VISIBLE
PCTFREE 10
INITRANS 2
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
);
