
-- ----------------------------
-- Table structure for SYS_IF_CONFIG_LINE_TL
-- ----------------------------
CREATE TABLE  "SYS_IF_CONFIG_LINE_TL" (
  "LINE_ID" VARCHAR2(255 BYTE) NOT NULL ,
  "LANG" VARCHAR2(50 BYTE) NOT NULL ,
  "LINE_NAME" VARCHAR2(50 BYTE) ,
  "LINE_DESCRIPTION" VARCHAR2(255 BYTE) ,
  "OBJECT_VERSION_NUMBER" NUMBER(38) DEFAULT 1 ,
  "REQUEST_ID" NUMBER(38) DEFAULT -1 ,
  "PROGRAM_ID" NUMBER(38) DEFAULT -1 ,
  "CREATED_BY" NUMBER(38) DEFAULT -1 ,
  "CREATION_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATED_BY" NUMBER(38) DEFAULT -1 ,
  "LAST_UPDATE_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATE_LOGIN" NUMBER(38) DEFAULT -1 
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN  "SYS_IF_CONFIG_LINE_TL"."LINE_ID" IS 'pk';
COMMENT ON COLUMN  "SYS_IF_CONFIG_LINE_TL"."LANG" IS '语言';
COMMENT ON COLUMN  "SYS_IF_CONFIG_LINE_TL"."LINE_NAME" IS '接口名称';
COMMENT ON COLUMN  "SYS_IF_CONFIG_LINE_TL"."LINE_DESCRIPTION" IS '接口描述';

-- ----------------------------
-- Primary Key structure for table SYS_IF_CONFIG_LINE_TL
-- ----------------------------
ALTER TABLE  "SYS_IF_CONFIG_LINE_TL" ADD CONSTRAINT "PK_SYS_IF_CONFIG_LINE_TL" PRIMARY KEY ("LINE_ID", "LANG");


