-- ----------------------------
-- Table structure for SYS_IF_CONFIG_HEADER_B
-- ----------------------------
CREATE TABLE  "SYS_IF_CONFIG_HEADER_B" (
  "HEADER_ID" VARCHAR2(255 BYTE) NOT NULL ,
  "INTERFACE_CODE" VARCHAR2(30 BYTE) NOT NULL ,
  "INTERFACE_TYPE" VARCHAR2(10 BYTE) NOT NULL ,
  "DOMAIN_URL" VARCHAR2(200 BYTE) NOT NULL ,
  "BODY_HEADER" VARCHAR2(2000 BYTE) ,
  "BODY_TAIL" VARCHAR2(2000 BYTE) ,
  "NAMESPACE" VARCHAR2(30 BYTE) ,
  "REQUEST_METHOD" VARCHAR2(10 BYTE) NOT NULL ,
  "REQUEST_FORMAT" VARCHAR2(30 BYTE) NOT NULL ,
  "REQUEST_CONTENTTYPE" VARCHAR2(80 BYTE) ,
  "REQUEST_ACCEPT" VARCHAR2(80 BYTE) ,
  "AUTH_FLAG" VARCHAR2(1 BYTE) NOT NULL ,
  "AUTH_USERNAME" VARCHAR2(80 BYTE) ,
  "AUTH_PASSWORD" VARCHAR2(200 BYTE) ,
  "ENABLE_FLAG" VARCHAR2(1 BYTE) NOT NULL ,
  "NAME" VARCHAR2(200 BYTE) NOT NULL ,
  "DESCRIPTION" VARCHAR2(255 BYTE) NOT NULL ,
  "SYSTEM_TYPE" VARCHAR2(10 BYTE) ,
  "MAPPER_CLASS" VARCHAR2(255 BYTE) ,
  "OBJECT_VERSION_NUMBER" NUMBER(38) DEFAULT 1 ,
  "REQUEST_ID" NUMBER(38) DEFAULT -1 ,
  "PROGRAM_ID" NUMBER(38) DEFAULT -1 ,
  "CREATED_BY" NUMBER(38) DEFAULT -1 ,
  "CREATION_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATED_BY" NUMBER(38) DEFAULT -1 ,
  "LAST_UPDATE_DATE" TIMESTAMP(6) DEFAULT CURRENT_TIMESTAMP ,
  "LAST_UPDATE_LOGIN" NUMBER(38) DEFAULT -1 ,
  "AUTH_TYPE" VARCHAR2(50 BYTE) DEFAULT 'BASIC_AUTH' ,
  "AUTH_URL" VARCHAR2(255 BYTE) ,
  "ACCESS_TOKEN_URL" VARCHAR2(255 BYTE) ,
  "CLIENT_ID" VARCHAR2(255 BYTE) ,
  "CLIENT_SECRET" VARCHAR2(255 BYTE) ,
  "GRANT_TYPE" VARCHAR2(50 BYTE) ,
  "SCOPE" VARCHAR2(100 BYTE) ,
  "SOAP_ACTION" VARCHAR2(100 BYTE) 
)
LOGGING
NOCOMPRESS
PCTFREE 10
INITRANS 1
STORAGE (
  INITIAL 65536 
  NEXT 1048576 
  MINEXTENTS 1
  MAXEXTENTS 2147483645
  BUFFER_POOL DEFAULT
)
PARALLEL 1
NOCACHE
DISABLE ROW MOVEMENT
;
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."HEADER_ID" IS 'pk';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."INTERFACE_CODE" IS '系统代码';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."INTERFACE_TYPE" IS '接口类型';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."DOMAIN_URL" IS '系统地址';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."BODY_HEADER" IS 'SOAP报文前缀';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."BODY_TAIL" IS 'SOAP报文后缀';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."NAMESPACE" IS 'SOAP命名空间';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."REQUEST_METHOD" IS '请求方法';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."REQUEST_FORMAT" IS '请求形式';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."REQUEST_CONTENTTYPE" IS '请求报文格式';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."REQUEST_ACCEPT" IS '请求接收类型';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."AUTH_FLAG" IS '是否需要验证';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."AUTH_USERNAME" IS '校验用户名';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."AUTH_PASSWORD" IS '校验密码';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."ENABLE_FLAG" IS '是否有效';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."NAME" IS '系统名称';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."DESCRIPTION" IS '系统描述';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."SYSTEM_TYPE" IS '系统类型';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."MAPPER_CLASS" IS '包装类';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."AUTH_TYPE" IS '校验模式';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."AUTH_URL" IS '取授权码的url';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."ACCESS_TOKEN_URL" IS '获取token的url';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."CLIENT_ID" IS '应用id';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."CLIENT_SECRET" IS '应用secret';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."GRANT_TYPE" IS '授权模式';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."SCOPE" IS '权限范围';
COMMENT ON COLUMN  "SYS_IF_CONFIG_HEADER_B"."SOAP_ACTION" IS 'SOAPACTION';

-- ----------------------------
-- Primary Key structure for table SYS_IF_CONFIG_HEADER_B
-- ----------------------------
ALTER TABLE  "SYS_IF_CONFIG_HEADER_B" ADD CONSTRAINT "SYS_INTERFACE_HEADER_PK" PRIMARY KEY ("HEADER_ID");

-- ----------------------------
-- Uniques structure for table SYS_IF_CONFIG_HEADER_B
-- ----------------------------
ALTER TABLE  "SYS_IF_CONFIG_HEADER_B" ADD CONSTRAINT "SYS_IF_CONFIG_HEADER_U1" UNIQUE ("INTERFACE_CODE") NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

-- ----------------------------
-- Checks structure for table SYS_IF_CONFIG_HEADER_B
-- ----------------------------